var app = angular.module('GridStack', ['gridstack-angular', 'ui.bootstrap.datetimepicker', "chart.js", 'ngMaterial', 'mwl.calendar', 'ngAnimate', 'ui.bootstrap', 'colorpicker.module', 'rgkevin.datetimeRangePicker'])
  //constant('_', window._).

  .directive('timeLine', function ($timeout) {
    return {
      restrict: 'A',
      link: function (scope, element, attrs) {

        //angular.element(element).css('border', '5px solid red');
        scope.$on('LastElem', function (event) {
          console.log("WWWWWWWWW");
          var timelines = element;
          eventsMinDistance = timelines.data('spacing');
          var timeline = timelines,
            timelineComponents = {};
          //cache timeline components
          timelineComponents['timelineWrapper'] = timeline.find('.events-wrapper');
          timelineComponents['eventsWrapper'] = timelineComponents['timelineWrapper'].children('.events');
          timelineComponents['fillingLine'] = timelineComponents['eventsWrapper'].children('.filling-line');
          timelineComponents['timelineEvents'] = timelineComponents['eventsWrapper'].find('a');
          //timelineComponents['timelineDates'] = parseDate(scope.nodes);
          timelineComponents['timelineDates'] = parseDate(timelineComponents['timelineEvents']);
          timelineComponents['eventsMinLapse'] = minLapse(timelineComponents['timelineDates']);
          timelineComponents['timelineNavigation'] = timeline.find('.cd-timeline-navigation');
          timelineComponents['eventsContent'] = timeline.children('.events-content');


          //assign a left postion to the single events along the timeline
          setDatePosition(timelineComponents, eventsMinDistance);


          //assign a width to the timeline
          var timelineTotWidth = setTimelineWidth(timelineComponents, eventsMinDistance);
          //the timeline has been initialize - show it
          timeline.addClass('loaded');
          scope.$watch(
            // This function returns the value being watched. It is called for each turn of the $digest loop
            function () {
              //return scope.nodes.length;
            },
            // This is the change listener, called when the value returned from the above function changes
            function (newValue, oldValue) {
              if (newValue !== oldValue) {
                // console.log('change');
                /*$timeout(function () {
                  timelineComponents['timelineWrapper'] = timeline.find('.events-wrapper');
                  timelineComponents['eventsWrapper'] = timelineComponents['timelineWrapper'].children('.events');
                  timelineComponents['fillingLine'] = timelineComponents['eventsWrapper'].children('.filling-line');
                  timelineComponents['timelineEvents'] = timelineComponents['eventsWrapper'].find('a');
                  timelineComponents['timelineDates'] = parseDate(timelineComponents['timelineEvents']);
                  timelineComponents['eventsMinLapse'] = minLapse(timelineComponents['timelineDates']);
                  timelineComponents['timelineNavigation'] = timeline.find('.cd-timeline-navigation');
                  timelineComponents['eventsContent'] = timeline.children('.events-content');
                  setDatePosition(timelineComponents, eventsMinDistance);
                  timelineTotWidth = setTimelineWidth(timelineComponents, eventsMinDistance);
                });*/

                // Only increment the counter if the value changed
                //scope.foodCounter = scope.foodCounter + 1;
              }
            }
          );

          //detect click on the next arrow
          timelineComponents['timelineNavigation'].on('click', '.next', function (event) {
            event.preventDefault();
            updateSlide(timelineComponents, timelineTotWidth, 'next');
          });
          //detect click on the prev arrow
          timelineComponents['timelineNavigation'].on('click', '.prev', function (event) {
            event.preventDefault();
            updateSlide(timelineComponents, timelineTotWidth, 'prev');
          });

          //detect click on the a single event - show new event content
          var kk = 0;
          timelineComponents['eventsWrapper'].on('click', 'a', function (event) {
            //if(kk%2==0) return;
            event.preventDefault();
            timelineComponents['timelineEvents'].removeClass('selected');
            $(this).addClass('selected');
            updateOlderEvents($(this));
            updateFilling($(this), timelineComponents['fillingLine'], timelineTotWidth);
            updateVisibleContent($(this), timelineComponents['eventsContent']);
            kk++;
            console.log(kk);
          });


          //on swipe, show next/prev event content
          timelineComponents['eventsContent'].on('swipeleft', function () {
            var mq = checkMQ();
            (mq == 'mobile') && showNewContent(timelineComponents, timelineTotWidth, 'next');
          });
          timelineComponents['eventsContent'].on('swiperight', function () {
            var mq = checkMQ();
            (mq == 'mobile') && showNewContent(timelineComponents, timelineTotWidth, 'prev');
          });

          //keyboard navigation
          $(document).keyup(function (event) {
            if (event.which == '37' && elementInViewport(timeline.get(0))) {
              showNewContent(timelineComponents, timelineTotWidth, 'prev');
            } else if (event.which == '39' && elementInViewport(timeline.get(0))) {
              showNewContent(timelineComponents, timelineTotWidth, 'next');
            }
          });


        });
      }

    }
  })
  .directive('timeLineLi', function ($timeout) {
    return {
      restrict: 'A',
      link: function (scope, element, attrs) {

        if (scope.$last) {
          $timeout(function () {
            scope.$emit('LastElem');


          });
        }
        //scope.$watch('thing', function () {
        //    var r = (Math.random() * 255).toFixed(0);
        //    var g = (Math.random() * 255).toFixed(0);
        //    var b = (Math.random() * 255).toFixed(0);
        //    angular.element(element).css('color', 'rgb(' + r + ',' + g + ',' + b + ')');
        //});
      }

    }
  })
  .factory('Excel', function ($window) {
    var uri = 'data:application/vnd.ms-excel;base64,',
      template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body><table>{table}</table></body></html>',
      base64 = function (s) { return $window.btoa(unescape(encodeURIComponent(s))); },
      format = function (s, c) { return s.replace(/{(\w+)}/g, function (m, p) { return c[p]; }) };
    return {
      tableToExcel: function (tableId, worksheetName) {
        var table = $(tableId),
          ctx = { worksheet: worksheetName, table: table.html() },
          href = uri + base64(format(template, ctx));
        return href;
      }
    };
  })

  .service('LoadService', function ($http) {
    var self = this;

    this.loadPromise = $http.get('data.json').success(function (data) {
      self.data1 = data;
    });
  })

  .config(function (calendarConfig) {
    calendarConfig.dateFormatter = 'moment';
    calendarConfig.displayEventEndTimes = true;
    //calendarConfig.showTimesOnWeekView = true;
    calendarConfig.templates.calendarWeekView = 'http://localhost/itouch/themeassets/angular/templates/calendarWeekView.html';
    calendarConfig.allDateFormats.moment.date.hour = 'HH:mm';
    console.log(calendarConfig);
  })
  .factory('calendefac', function () {

    function show(action, event) {



    }

    return {
      show: show
    };

  }).filter('regex', function () {
    return function (input, field, query, regex, a) {
      //console.log(input);
      //console.log(field);
      //console.log(regex);

      var out = [];
      if (/[^\*\.\(\)\!\[\]\{\}\^\&\%\#\@\\]{2}/.test(query)) {
        var patt = new RegExp(regex);
        for (var i = 0; i < input.length; i++) {
          var duplicate = false;
          for (var j = 0; j < a.length; j++) {
            console.log('comparing - ' + a[j].TeamName + ' and ' + input[i].name);
            if (a[j].TeamName == input[i].name)
              duplicate = true;
          }
          if (patt.test(input[i][field].toLowerCase()) && !duplicate)
            out.push(input[i]);
        }
      }
      //console.log(out);
      return out;
    };
  })
  .controller('DemoCtrl', function (Excel, $timeout, $scope, $q, $filter, $http, $log, $interval, $mdDialog, moment, calendefac, calendarConfig, $uibModal, $q) {
    $scope.widgets = [];

    // local angular url
    //  var baseUrl = "http://localhost:3001/api/";
    //  var YiibaseUrl = "http://localhost/NimbusLionPortal/index.php/Treemapapi";
    //  var base_url = "http://localhost/NimbusLionPortal/index.php/";
    //  var main_url = "http://localhost/NimbusLionPortal/index.php";


    // Production angular url
      var baseUrl = "http://34.47.139.157:3001/api/";
      var YiibaseUrl = "http://34.47.139.157/fms/index.php/Treemapapi";
      var base_url = "http://34.47.139.157/fms/index.php/";
     // var main_url = Base_Url;
      var main_url = "http://34.47.139.157/fms/index.php";

    // Local Lasitha angular url
    // var baseUrl = "http://34.47.139.157:3001/api/";
    // var YiibaseUrl = "http://localhost:82/index.php/Treemapapi";
    // var base_url = "http://localhost:82/index.php/";
    // // var main_url = Base_Url;
    // var main_url = "http://localhost:82/index.php";


    // var ctx = document.getElementById("canvas").getContext("2d");
    // var ctx2 = document.getElementById("canvas2").getContext("2d");
    // var ctx3 = document.getElementById("canvas3").getContext("2d");
    // var ctx4 = document.getElementById("canvas4").getContext("2d");
    // var ctx5 = document.getElementById("canvas5").getContext("2d");
    // var ctx6 = document.getElementById("canvas6").getContext("2d");

    // var data = {
    // 	labels: ["Red","Green",	"Yellow"],
    // 	datasets: [
    // 		{
    // 			data: [300, 50, 100],
    // 			backgroundColor: ["#FF6384",	"#36A2EB","#FFCE56" ,"#8E44AD"],
    // 			hoverBackgroundColor: ["#FF6384","#36A2EB",	"#FFCE56"]
    // 		}]
    // };
    // var data1 = {
    // 	labels: ["Red","Green",	"Yellow","Green",	"Yellow"],
    // 	datasets: [
    // 		{
    // 			data: [300, 50, 100 , 140,190],
    // 			backgroundColor: ["#cc0000","#FF6384",	"#36A2EB","#FFCE56","#8E44AD", "#713b3b"],
    // 			hoverBackgroundColor: ["#FF6384","#36A2EB",	"#FFCE56"]
    // 		}]
    // };

    // Chart.pluginService.register({
    // 	beforeRender: function (chart) {
    // 		if (chart.config.options.showAllTooltips) {
    // 			// create an array of tooltips
    // 			// we can't use the chart tooltip because there is only one tooltip per chart
    // 			chart.pluginTooltips = [];
    // 			chart.config.data.datasets.forEach(function (dataset, i) {
    // 				chart.getDatasetMeta(i).data.forEach(function (sector, j) {
    // 					chart.pluginTooltips.push(new Chart.Tooltip({
    // 						_chart: chart.chart,
    // 						_chartInstance: chart,
    // 						_data: chart.data,
    // 						_options: chart.options.tooltips,
    // 						_active: [sector]
    // 					}, chart));
    // 				});
    // 			});

    // 			// turn off normal tooltips
    // 			chart.options.tooltips.enabled = false;
    // 		}
    // 	},
    // 	afterDraw: function (chart, easing) {
    // 		if (chart.config.options.showAllTooltips) {
    // 			// we don't want the permanent tooltips to animate, so don't do anything till the animation runs atleast once
    // 			if (!chart.allTooltipsOnce) {
    // 				if (easing !== 1)
    // 					return;
    // 				chart.allTooltipsOnce = true;
    // 			}

    // 			// turn on tooltips
    // 			chart.options.tooltips.enabled = true;
    // 			Chart.helpers.each(chart.pluginTooltips, function (tooltip) {
    // 				tooltip.initialize();
    // 				tooltip.update();
    // 				// we don't actually need this since we are not animating tooltips
    // 				tooltip.pivot();
    // 				tooltip.transition(easing).draw();
    // 			});
    // 			chart.options.tooltips.enabled = false;
    // 		}
    // 	}
    // })

    // var myPieChart = new Chart(ctx, {
    // 	type: 'pie',
    // 	data: data,
    // 	options: {
    // 		showAllTooltips: true
    // 	}
    // });

    // var myPieChart = new Chart(ctx2, {
    // 	type: 'doughnut',
    // 	data: data1,
    // 	options: {
    // 		showAllTooltips: true
    // 	}
    // });

    // var myPieChart = new Chart(ctx3, {
    // 	type: 'bar',
    // 	data: data1,
    // 	options: {
    // 		showAllTooltips: true
    // 	}
    // });

    // var myPieChart = new Chart(ctx4, {
    // 	type: 'polarArea',
    // 	data: data,
    // 	options: {
    // 		showAllTooltips: true
    // 	}
    // });
    // var myPieChart = new Chart(ctx5, {
    // 	type: 'radar',
    // 	data: data,
    // 	options: {
    // 		showAllTooltips: true
    // 	}
    // });var myPieChart = new Chart(ctx6, {
    // 	type: 'polarArea',
    // 	data: data,
    // 	options: {
    // 		showAllTooltips: true
    // 	}
    // });


    $scope.toggle_menu = false;
    $scope.toggle_sidebar = true;
    $scope.options = {
      cellHeight: 75,
      verticalMargin: 4

    };

    $scope.export = function (tableId) { //ex: '#my-table'
      var exportHref = Excel.tableToExcel(tableId, 'WireWorkbenchDataExport');
      $timeout(function () { location.href = exportHref; }, 100); // trigger download
    }
    //$scope.aaa = "";
    $scope.aaa = "FFFF";
    $scope.showItem = false;
    $scope.show_speed_details = false;
    $scope.show_speed_details_view = false;
    $scope.showHeader = true;
    $scope.Header = "No Data Found";

    $scope.exportToPdf = function () {
      html2canvas(document.getElementById('customers'), {
        onrendered: function (canvas) {
          var data = canvas.toDataURL();
          var docDefinition = {
            content: [{
              image: data,

            }]
          };
          pdfMake.createPdf(docDefinition).download("example.pdf");
          pdfMake.createPdf(docDefinition).download("test.pdf");
        }
      });
    }

    $scope.option_restricted = {
      cellHeight: 100,
      verticalMargin: 4,
      disableDrag: true,
      disableResize: true
    },
      $scope.option_employee = {
        cellHeight: 175,
        verticalMargin: 4,
        disableDrag: true,
        disableResize: true
      },

      $scope.selectedmap = null,
      $scope.selected_perent = null,
      $scope.Name = null,
      $scope.Ref = null,
      $scope.desc = null,

      $scope.a = function (aa) {


      }

    var vehicle_no = [];

    // $http.get(main_url + "/dashboard/GetIncompleteSchedules").success(function (res) {
    //   $scope.incompleteSchedules = res.data.final_card_data;
    //   $scope.detailtable = res.data.detailtable;
    //   console.log(res);
    // });

    $http({
      url: main_url + "/dashboard/GetIncompleteSchedules",
      method: "POST",
      headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
      data: $.param({ SelectDate: '-1' })
    }).then(function successCallback(res) {
      console.log(res);
      $scope.incompleteSchedules = res.data.data.final_card_data;
      $scope.detailtable = res.data.data.detailtable;
      //console.log(res.data.data);
      // this callback will be called asynchronously
      // when the response is available
    }, function errorCallback(res) {
      console.log(res);
      // called asynchronously if an error occurs
      // or server returns response with an error status.
    });



    $http.get(main_url + "/dashboard/GetAllVehiclesBySites").success(function (res) {
      $scope.vehicle_no = res;
    });

    $http.get(main_url + "/dashboard/GetAllSites").success(function (res) {
      $scope.site = res;
      console.log(res);
    });

    $scope.vehicleDetailView = function (data) {
      $scope.selectedVehicle = data;

      if (data.delay_status == 1) {
        $scope.myObj = {
          "color": "white",
          "background-color": "#fb7575"
        }
      }

      if (data.delay_status != 1) {
        $scope.myObj = {
          "color": "white",
          "background-color": "#00c851"
        }
      }
      if (data.status == 1) {
        $scope.myObj = {
          "color": "white",
          "background-color": "#eadc28"
        }
      }
      if (data.status == 2) {
        $scope.myObj = {
          "color": "white",
          "background-color": "#3598dc"
        }
      }



      console.log($scope.selectedVehicle);
    }

    $scope.getVehicle = function (site) {
      $http({
        url: main_url + "/dashboard/GetVehiclesBySites",
        method: "POST",
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        data: $.param({ SiteId: JSON.parse(site)["id"] })
      }).success(function (data, status, headers, config) {
        //console.log("location", data);
        $scope.vehicle_no = data;
        console.log(data);
      });

    }

    //$scope.vehicle_no = ["LJ-7651", "LJ-8115", "LK-2968"]

    //console.log("$scope.vehicle_no", $scope.vehicle_no);

    var locations = [];  //this will be new array with no duplicate value

    // var promise =  $http({
    //   url: main_url + "/dashboard/GetLocationByVehicles",
    //   method: "POST",
    //   headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    //   data: $.param({ vehicle_no: "" })
    // }).success(function (data, status, headers, config) {
    //         return data; 
    //         console.log(data);

    // });
    // promise.then(function(result) {

    //   for (var i = 0; i < result.data.length; i++) {

    //     if (!ckeckContains(result.data[i])) {
    //       locations.push(result.data[i]);
    //     }
    //   }

    // console.log("locations" , locations)

    // var promises = [];
    //  angular.forEach(locations, function (item) {
    //   //console.log(a++);

    //  var p = $http({
    //         url: main_url + "/dashboard/GetVehicleData",
    //         method: "POST",
    //         headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    //         data: $.param({ startDate: "2018-01-01%2000:00", 
    //                         selectedLocation: item.geoLocationProperties.geoLocationId, 
    //                         endDate: "2018-12-01%2000:00"})
    //       });
    //     //console.log(p);
    //     promises.push(p);

    //  });
    // $q.all(promises).then(function(data) {
    //   console.log('Both promises have resolved');
    //   console.log('Both promises have resolved', data.length);
    //   for (i = 0; i < data.length; i++){ //big loop

    //     for (s = 0; s < data[i].data.length; s++){ //small loop aka delay loop
    //         console.log("End of round" + i);
    //     }
    //     console.timeEnd(i);
    // }
    // },function(err){
    //   console.log('ERROR-$q ALL -',err)
    // });
    //});


    var location_items = [];
    $scope.location = [];
    console.log("location");
    $http({
      url: main_url + "/dashboard/GetAllLocations",
      method: "POST",
      headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
      data: $.param({ vehicle_no: "" })
    }).success(function (data, status, headers, config) {
      //console.log("location", data);
      $scope.location = data;
      /// console.log(locations);
    });


    $scope.getLocation = function (vehicle_no) {
      // console.log("aaaa");
      // 

    }
    var f = [];
    var a = 0;




    function ckeckContains(obj) {
      var flag = false;
      for (var i = 0; i < locations.length; i++) {
        if (locations[i].geoLocationProperties.geoLocationId == obj.geoLocationProperties.geoLocationId)
          return true;
        else
          flag = false;
      }
      return flag;
    }



    var date = moment.utc().format('YYYY-MM-DD HH:mm:ss');

    // console.log(date); // 2015-09-13 03:39:27
    var local = moment(moment.utc("Feb 26, 2018 1:53:27 PM").toDate()).local().format('YYYY-MM-DD HH:mm:ss');

    var now = "04/09/2013 15:00:00";
    var then = "04/09/2013 14:20:30";

    moment.utc(moment(now, "DD/MM/YYYY HH:mm:ss").diff(moment(then, "DD/MM/YYYY HH:mm:ss"))).format("HH:mm:ss")
    // console.log(now ,then , SS);    




    $scope.showTable = false;
    $scope.final_data = [];
    $scope.final_data_details = [];


   // $http({
   //   url: main_url + "/Volume/GetAllDataAPI",
   //   method: "POST",
   //   headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
   //   data: $.param({ startDate: "" })
  //  }).success(function (data, status, headers, config) {
   //   $scope.volume = data;
   //   console.log($scope.volume);

   // });



    $scope.getVehicleSummaryforvTimeline = function (vehicle_id, selectedLocation, endDate, startDate) {
      console.log(" This is checking VID -" + vehicle_id + " SL-" + selectedLocation + " SD -" + startDate + " ED - " + endDate);
      $scope.showItem = false;
      $scope.showHeader = false;
      $http({
        url: main_url + "/dashboard/GetWaitingTimeFroTimeline",
        method: "POST",
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        data: $.param({ startDate: startDate, selectedLocation: selectedLocation, endDate: endDate, VehicleNumber: vehicle_id })
      }).success(function (data, status, headers, config) {
        var allFilteredData = [];
        var dataSet = [];
        var vehicle_no = [];
        var ReverseArray = [];

        //console.log("dataaa", data);

        if (data.length == 0) {
          $scope.Header = "No Record Found";
          $scope.showHeader = true;

        }
        else {
          for (var i = 0; i < data.length; i++) {

            if (data[i].waiting_time.split('.')[0] > "00:01:00" && data[i].volume != "0.00") {
              allFilteredData.push({
                "vehicle_no": data[i].vehicleId,
                "arrivaltime": moment(moment.utc(data[i].arrivalTime).toDate()).local().format('YYYY-MM-DD HH:mm:ss'),
                "departuretime": moment(moment.utc(data[i].departureTime).toDate()).local().format('YYYY-MM-DD HH:mm:ss'),
                "company_id": data[i].geoLocationId,
                "company_name": data[i].name,
                "waiting_time": data[i].waiting_time.split('.')[0],
                "volume": data[i].volume,
                //"ratio": data[i].volume / (Math.abs(new Date(data[i].arrivalTime) - new Date(data[i].departureTime)) / (1000*60))
                "ratio": ((+data[i].waiting_time.split(':')[0]) * 60 * 60 + (+data[i].waiting_time.split(':')[1]) * 60 + (+data[i].waiting_time.split(':')[2])) / data[i].volume
              });
            }
          }

          console.log("data", allFilteredData);

          $scope.finaldataForVtimeline = allFilteredData;
          $scope.showItem = true;

        }



      }).error(function (data, status, headers, config) {
        $scope.status = status;
        //  console.log($scope.status);
      });



    }


    $scope.getVehicleOverallSummaryforvTimeline = function (vehicle_id, selectedLocation, endDate, startDate) {
      $scope.showHeader = false;
      console.log(vehicle_id, selectedLocation, startDate, endDate);
      $scope.showItem = false;
      $http({
        url: main_url + "/dashboard/GetWaitingTimeFroTimeline",
        method: "POST",
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        data: $.param({ startDate: startDate, selectedLocation: selectedLocation, endDate: endDate, VehicleNumber: vehicle_id })
      }).success(function (data, status, headers, config) {
        var allFilteredData = [];
        var dataSet = [];
        var vehicle_no = [];
        var ReverseArray = [];

        if (data.length == 0) {
          $scope.Header = "No Record Found";
          $scope.showHeader = true;

        }
        else {

          //console.log("data", data);
          for (var i = 0; i < data.length; i++) {
            allFilteredData.push({
              "vehicle_no": data[i].vehicleId,
              "arrivaltime": moment(moment.utc(data[i].arrivalTime).toDate()).local().format('YYYY-MM-DD HH:mm:ss'),
              "departuretime": moment(moment.utc(data[i].departureTime).toDate()).local().format('YYYY-MM-DD HH:mm:ss'),
              "company_id": data[i].geoLocationId,
              "company_name": data[i].name,
              "waiting_time": data[i].waiting_time.split('.')[0],
              "ratio": ((+data[i].waiting_time.split(':')[0]) * 60 * 60 + (+data[i].waiting_time.split(':')[1]) * 60 + (+data[i].waiting_time.split(':')[2])) / data[i].volume

            });

          }

          $scope.finaldataForVtimeline = allFilteredData;
          console.log($scope.finaldataForVtimeline);
          $scope.showItem = true;
        }

      }).error(function (data, status, headers, config) {
        $scope.status = status;
        //  console.log($scope.status);
      });



    }
    var location_no = 0
    var volumeData = [];

    $scope.getTimeSpentOutletWithRatio = function (vehicle_id, endDate, startDate) {


      $scope.showTable = false;;
      $scope.showHeader = false;

      var allFilteredData = [];

      $http({
        url: main_url + "/dashboard/GetWaitingTime",
        method: "POST",
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        data: $.param({ startDate: startDate, endDate: endDate, VehicleNumber: vehicle_id })
      }).success(function (data, status, headers, config) {



        if (data.length == 0) {
          $scope.Header = "No Record Found";
          $scope.showHeader = true;

        }

        else {
            

          for (var i = 0; i < data.length; i++) {
            console.log("aaaa", data[i].waiting_time);
            if (data[i].waiting_time.split('.')[0] > "00:01:00" && data[i].volume != 0) {
              allFilteredData.push({
                "vehicle_no": data[i].vehicleId,
                "arrivaltime": moment(moment.utc(data[i].arrivalTime).toDate()).local().format('YYYY-MM-DD HH:mm:ss'),
                "departuretime": moment(moment.utc(data[i].departureTime).toDate()).local().format('YYYY-MM-DD HH:mm:ss'),
                "company_id": data[i].geoLocationId,
                "company_name": data[i].name,
                "waiting_time": data[i].waiting_time,
                "volume": data[i].volume,
                "ratio": ((+data[i].waiting_time.split(':')[0]) * 60 * 60 + (+data[i].waiting_time.split(':')[1]) * 60 + (+data[i].waiting_time.split(':')[2])) / data[i].volume

              });
            }
          }
          $scope.finaldataWithRatioForTable = allFilteredData;

          $scope.showTable = true;

        }
      }).error(function (data, status, headers, config) {
        $scope.status = status;
      });


    }


    $scope.getTimeSpentOutlet = function (vehicle_id, endDate, startDate) {


      $scope.showTable = false;;
      $scope.showHeader = false;

      var allFilteredData = [];

      $http({
        url: main_url + "/dashboard/GetWaitingTimeData",
        method: "POST",
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        data: $.param({ startDate: startDate, endDate: endDate, VehicleNumber: vehicle_id })
      }).success(function (data, status, headers, config) {


        if (data.length == 0) {
          $scope.Header = "No Record Found";
          $scope.showHeader = true;

        }

        else {
console.log('*********');
            console.log(data);
          for (var i = 0; i < data.length; i++) {
            allFilteredData.push({
              "vehicle_no": data[i].vehicle,
              "arrivaltime": moment(moment.utc(data[i].arrival_time).toDate()).local().format('YYYY-MM-DD HH:mm:ss'),
              "departuretime": moment(moment.utc(data[i].departure_time).toDate()).local().format('YYYY-MM-DD HH:mm:ss'),
              "company_id": data[i].location_id,
              "company_name": data[i].outlet_name,
              "waiting_time": data[i].stay_time,
              "volume": "",
              "ratio": ""

            });
          }
          $scope.finaldataForTable = allFilteredData;

          $scope.showTable = true;

        }
      }).error(function (data, status, headers, config) {
        $scope.status = status;
      });


    }



    $scope.loadItemDetails = function (date) {
      var final_data_details = {};
      for (var i = 0; i < $scope.final_data.length; i++) {
        if ($scope.final_data[i].datetime == date) {
          final_data_details = $scope.final_data[i];

        }
      }
      $scope.final_data_details = final_data_details;
    }

    $scope.time = [{ timestamp: "Feb 6, 2018 6:35:06 AM" }, { timestamp: "Feb 8, 2018 11:35:06 AM" }, { timestamp: "Feb 20, 2018 16:35:06 PM" }]

    $scope.addWidget = function (sec) {
      var newWidget = { x: 0, y: 0, width: 1, height: 1, type: $scope.selectedmap, parent: $scope.selected_perent, name: $scope.Name, ref: $scope.Ref, desc: $scope.desc };

      //console.info(newWidget);
      var items = {
        items: newWidget
      };
      //console.info(newWidget);
      $http.post(baseUrl + 'division', items).success(function (res) {
        $scope.widgets.push(res);
        $scope.done = true;
      });
    };
    $scope.moveWidget = function () {
      $scope.widgets[0].x = 1;
      $scope.widgets[0].width = 2;
      $scope.widgets[0].height = 2;
    };
    $scope.removeWidget = function (w) {
      var index = $scope.widgets.indexOf(w);
      $scope.widgets.splice(index, 1);
      // console.info(w._id);
      var items = {
        items: w._id
      };
      $http.post(baseUrl + 'ItemDelete', items).success(function (res) {
        //   console.log(res);
        $scope.done = true;

      });
    };

    $scope.onChange = function (event, items) {
      $log.log("onChange event: " + event + " items:" + items);
    };
    $scope.onDragStart = function (event, ui) {
      $log.log("onDragStart event: " + event + " ui:" + ui);
    };
    $scope.onDragStop = function (event, ui) {
      $log.log("onDragStop event: " + event + " ui:" + ui);
    };
    $scope.onResizeStart = function (event, ui) {
      $log.log("onResizeStart event: " + event + " ui:" + ui);
    };
    $scope.onResizeStop = function (event, ui) {
      $log.log("onResizeStop event: " + event + " ui:" + ui);
    };
    $scope.onItemAdded = function (item) {
      $log.log("onItemAdded item: " + item);
    };
    $scope.onItemRemoved = function (item) {
      $log.log("onItemRemoved item: " + item);
    };


    $scope.goBack = function () {
      $scope.current_sector_list = $scope.floors;
    },

      // login
      $scope.user = {};
    $scope.is_logged_in = false;
    $scope.login = function () {
      // console.log('login');
      if ($scope.user.name === 'admin' && $scope.user.password === 'Welcome@1') {
        console.log('is_logged_in');
        $scope.is_logged_in = true;
        $cookies.put('user_name', $scope.user.name);
        $cookies.put('password', $scope.user.password);
      } else {
        //   console.log('is_logged_out');
        $scope.is_logged_in = false;
      }
    };

    $scope.parentmap = null;
    $scope.reference = null;
    $scope.selectedmaptype = function () {
      $scope.value = $scope.selectedmap;
      $scope.reference = null;

      switch ($scope.selectedmap) {
        case 'company':
          $http.get(YiibaseUrl + '/getallcompany').success(function (res) {
            if (!res.error) {
              //  console.info(res);
              $scope.reference = res;
            }
          });
          break;
        case 'sector':
          $http.get(YiibaseUrl + '/getallsector').success(function (res) {
            if (!res.error) {
              $scope.reference = res;
            }
          });
          break;
        case 'cluster':
          $http.get(YiibaseUrl + '/getallcluster').success(function (res) {
            if (!res.error) {
              $scope.reference = res;
            }
          });
          break;
        case 'site':
          $http.get(YiibaseUrl + '/getallsite').success(function (res) {
            if (!res.error) {
              $scope.reference = res;
            }
          });
          break;
        case 'account':
          $http.get(YiibaseUrl + '/getallaccount').success(function (res) {
            if (!res.error) {
              $scope.reference = res;
            }
          });
          break;
        case 'category':
          $http.get(YiibaseUrl + '/getallcategory').success(function (res) {
            if (!res.error) {
              $scope.reference = res;
              // console.info(res)
            }
          });
          break;
        case 'supplier':
          $http.get(YiibaseUrl + '/getallsuplier').success(function (res) {
            if (!res.error) {
              $scope.reference = res;
            }
          });
          break;
        case 'designation':
          $http.get(YiibaseUrl + '/getalldesignation').success(function (res) {
            if (!res.error) {
              $scope.reference = res;
            }
          });
          break;

        default:

      }

      $scope.parentmap = null;
      if ($scope.value === "account") {
        var items = {
          item: "site"
        };
        $http.post(baseUrl + 'getsites', items).success(function (res) {
          //  console.info(res);
          $scope.done = true;
          $scope.parentmap = res;
        });
      }

    };

    $scope.selectedparent = function () {
      //  console.info($scope.selectedperent);
      $scope.selected_perent = $scope.selectedperent;
    };


    $scope.displaywidjets = [];

    $http.get(baseUrl + 'division').success(function (res) {
      if (!res.error) {
        $scope.displaywidjets.push(res);
        // console.info($scope.displaywidjets);
      }
    });

    $scope.clickeditem = [{}];
    //$scope.itemeid=null;
    $scope.onitemClick = function (z) {

      $scope.getemployebycategory(z);
      if (z.clicked === undefined || z.clicked === false) {
        var items = {
          items: z._id
        };
        $http.post(baseUrl + 'Getitems', items).success(function (res) {
          // console.log(res);
          $scope.done = true;
          //console.info(z.type);
          if (z.type === "site") {
            $scope.displaywidjets = [];
            res.forEach(function (item) {
              $scope.displaywidjets.push(item);

            });
          }
          else {
            res.forEach(function (item) {
              $scope.displaywidjets.push(item);

            });
          }
        });
        z.clicked = true;
      }
      else {
        return;
      }
    },

      $scope.getemployebycategory = function (z) {
        $scope.refid = z.ref;
        console.info($scope.refid);
        $scope.emplyees = [];
        if (z.type === "category") {
          $http.post(YiibaseUrl + '/getallemployeebycategory', $scope.refid).success(function (res) {
            $scope.done = true;
            $scope.emplyees = res;
            // console.info(res);
          });

        }
        else if (z.type === "supplier") {
          $http.post(YiibaseUrl + '/getallemployeebysupplyer', $scope.refid).success(function (res) {
            $scope.done = true;
            $scope.emplyees = res;
            //  console.info(res);
          });
        }

      };


    $scope.addparent = function (z) {
      //console.info(z);
      for (var i = 0; i < $scope.widgets.length; i++) {
        $scope.widgets[i].isPatent = false;
      }
      z.isPatent = true;
      console.info(z._id);
      $scope.selected_perent = z._id;
      var items = {
        items: z._id
      };
      $http.post(baseUrl + 'Getitems', items).success(function (res) {
        // console.log(res);
        $scope.done = true;
        //console.info(z.type);
        if (z.type === "site") {
          $scope.widgets = [];
          $scope.widgets = res;
        }
      });
    },

      $scope.save_layout = function () {

        console.info($scope.widgets);
        var items = {
          items: $scope.widgets
        };

        $http.post(baseUrl + 'DivisionUpdate', items).success(function (res) {
          //  console.log(res);
          $scope.done = true;

        });
        $mdDialog.show(
          $mdDialog.alert()
            .parent(angular.element(document.querySelector('#popupContainer')))
            .clickOutsideToClose(true)
            .title('Massage')
            .textContent('Update Successfully.')
            .ariaLabel('Alert Dialog Demo')
            .ok('ok')

        );
      };

    //get data from node for first layout update
    $http.get(baseUrl + 'Getallitems').success(function (res) {
      $scope.widgets = res;
      $scope.done = true;

    });

    $scope.edititemonclick = function (w) {

      /* console.info(w);
      var items ={
      items:w._id
    };
    $http.post(baseUrl + 'Getitems' ,items).success( function (res){
    // console.log(res);
    $scope.done = true;
    //console.info(z.type);
    if(w.type === "site"){
    $scope.widgets=[];
    $scope.widgets=res;
  }
  });  */
    };

    $scope.showLoading = false;
    var dataSet = [];
    var vehicle_no = [];
    var ReverseArray = [];
    var e = 0;

    $scope.l_data = [];
    var promise = $q.all([]);
    var allFilteredData = [];
    // $scope.getTimeSpentOutletNew = function (vehicle_id, endDate, startDate) {
    //   console.log("aaaaaaaaaaaa");
    //   $scope.showLoading = true;

    //   $scope.finaldataForTable = [];
    //   angular.forEach(location_items, function (item) {
    //     promise = promise.then(function () {
    //       return $timeout(function () {
    //         $http({
    //           url: main_url + "/dashboard/GetVehicleData",
    //           method: "POST",
    //           headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    //           data: $.param({
    //             startDate: startDate,
    //             selectedLocation: item.geoLocationProperties.geoLocationId,
    //             endDate: endDate,
    //             VehicleNumber: vehicle_id
    //           })
    //         }).success(function (data, status, headers, config) {
    //           //console.log(data);
    //           for (var i = 0; i < data.result.length; i++) {
    //             allFilteredData.push({
    //               "v_no": data.result[i].vehicleId,
    //               "date": moment(data.result[i].timestamp).format('YYYY/MM/DD'),
    //               "datetime": moment(moment.utc(data.result[i].timestamp).toDate()).local().format('YYYY-MM-DD HH:mm:ss'),
    //               "alarmtype": data.result[i].alarmType,
    //               "company_id": data.result[i].geoLocationProperties.companyId,
    //               "company_name": data.result[i].geoLocationProperties.name,
    //               "address": data.result[i].geoLocationProperties.address,
    //               "full_date": data.result[i].timestamp,
    //             });
    //           }


    //         });
    //       }, 600);
    //     });
    //   });


    //   promise.finally(function () {
    //     //console.log('Chain finished!',allFilteredData.length);
    //     // console.log('Chain finished!',allFilteredData);
    //     $scope.dataAlarmTypeOne = [];

    //     var selectedData = [];
    //     for (var i = 0; i < allFilteredData.length; i++) {

    //       if (allFilteredData[i].v_no == vehicle_id) {
    //         selectedData.push(allFilteredData[i]);
    //       }
    //     }

    //     var data_status = [];
    //     var waiting = true;
    //     for (var i = 0; i < selectedData.length; i++) {
    //       if (selectedData[i].alarmtype == 1) {
    //         if (waiting) {
    //           selectedData[i].status = "Arrival";
    //           data_status.push(selectedData[i]);
    //           waiting = false;

    //         }
    //       }
    //       else if (selectedData[i].alarmtype == 3) {
    //         selectedData[i].status = "Departure";
    //         data_status.push(selectedData[i]);
    //         waiting = true;

    //       }
    //     }
    //     var ii = 0;
    //     var final = [];

    //     var ii = 0;
    //     var final = [];


    //     var length = data_status.length;
    //     var final_data = [];
    //     var data_withwaiting = [];
    //     $scope.fulldata = [];
    //     for (var i = length - 1; i >= 0; i--) {
    //       final_data.push(data_status[i]);

    //     }

    //     //console.log(final_data);
    //     for (var i = 0; i < final_data.length; i++) {
    //       if (ii < final_data.length ) {


    //         if (final_data[i].alarmtype == 1) {
    //           var now = final_data[ii + 1].datetime;

    //           var then = final_data[ii].datetime;
    //           //console.log(then);

    //           if(now != then){
    //           var watingTime = moment.utc(moment(now, "YYYY-MM-DD HH:mm:ss").diff(moment(then, "YYYY-MM-DD HH:mm:ss"))).format("HH:mm:ss");
    //          // console.log("now",now , "then" , then , watingTime);

    //           if (watingTime > "00:00:50") {
    //           //  console.log(watingTime);
    //             final_data[i].departureTime = now;
    //             final_data[i].watingTime = watingTime;
    //             $scope.finaldataForTable.push(final_data[i]);
    //           }
    //           ii += 2;
    //         }
    //         }
    //       }
    //     }
    //    // console.log("$scope.finaldataForTable", $scope.finaldataForTable);
    //     $scope.showLoading = false;
    //     $scope.showTable = true;

    //   });

    // }

    $scope.refreshIncompleteSchedules = function (selectedDate) {

      $http({
        url: main_url + "/dashboard/GetIncompleteSchedules",
        method: "POST",
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        data: $.param({ SelectDate: selectedDate })
      }).then(function successCallback(res) {
        console.log(res);
        $scope.incompleteSchedules = res.data.data.final_card_data;
        $scope.detailtable = res.data.data.detailtable;
        //console.log(res.data.data);
        // this callback will be called asynchronously
        // when the response is available
      }, function errorCallback(res) {
        console.log(res);
        // called asynchronously if an error occurs
        // or server returns response with an error status.
      });
      //.success(function (res, status, headers, config) {
      //   $scope.incompleteSchedules = res.data.final_card_data;
      //   $scope.detailtable = res.data.detailtable;
      //   console.log(res);
      // }).error(function (data, status, headers, config) {
      //   $scope.status = status;
      // });


    }



    $scope.getAverageSpeed = function (vehicle_id, endDate, startDate) {
      console.log(vehicle_id, endDate, startDate);
      console.log(moment(endDate).format('YYYY-MM-DDTHH:mm:ss'));
      $scope.show_speed_details = false;
      $scope.show_speed_details_view = false;
      $scope.showHeader = false;
      var diff = Math.abs(new Date(endDate) - new Date(startDate)) / 1000;
      if (diff > 18000) {
        window.alert("Time Range is Too Long.. Please try again");
      }


      $http({
        url: main_url + "/dashboard/GetSpeedByVehicle",
        method: "POST",
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        data: $.param({
          startDate: moment(startDate).format('YYYY-MM-DDTHH:mm:ss'),
          endDate: moment(endDate).format('YYYY-MM-DDTHH:mm:ss'),
          VehicleNumber: vehicle_id
        })
      }).success(function (data, status, headers, config) {
        console.log(data);
        Distance(data.result);
        //$scope.diff  = Math.abs(new Date(endDate) - new Date(startDate)) / (1000*3600);

        // $scope.speed = $scope.distance /$scope.diff;


      });
    }

    var colors = ['rgba(255, 99, 132, 0.2)', 'rgba(54, 162, 235, 0.2)', 'rgba(255, 206, 86, 0.2)', 'rgba(75, 192, 192, 0.2)', 'rgba(153, 102, 255, 0.2)', 'rgba(255, 159, 64, 0.2)', 'rgba(255, 99, 132, 0.2)', 'rgba(54, 162, 235, 0.2)', 'rgba(255, 206, 86, 0.2)', 'rgba(75, 192, 192, 0.2)', 'rgba(153, 102, 255, 0.2)', 'rgba(255, 159, 64, 0.2)'];
    var bordercolors = ['rgba(255,99,132,1)', 'rgba(54, 162, 235, 1)', 'rgba(255, 206, 86, 1)', 'rgba(75, 192, 192, 1)', 'rgba(153, 102, 255, 1)', 'rgba(255, 159, 64, 1)', 'rgba(255,99,132,1)', 'rgba(54, 162, 235, 1)', 'rgba(255, 206, 86, 1)', 'rgba(75, 192, 192, 1)', 'rgba(153, 102, 255, 1)', 'rgba(255, 159, 64, 1)']

    $scope.show_more_details = function () {
      $scope.show_speed_details_view = true;

    }

    function vehicleDetailView() {
      console.log("aaaaaaaa");
    }

    function Distance(VehicleDataList) {
      //console.log("VehicleDataList", VehicleDataList);
      var distance = 0;
      var prveGpsData = null;
      var preveTimeStatmp = 0;
      var speed;
      var asd = [];
      var lable = [];
      var speedarray = [];
      var actualTime = 0;
      var background_color = [];
      var border_color = [];
      var myChart = null;

      for (var i = 1; i < VehicleDataList.length; i++) {
        //console.log("IgnitionOn", VehicleDataList[i].ignitionOn);

        if (VehicleDataList[i - 1].gpsData != null && (VehicleDataList[i].ignitionOn || VehicleDataList[i].speed >= 0.1)) {
          var diff = Math.abs(new Date(VehicleDataList[i].timestamp) - new Date(VehicleDataList[i - 1].timestamp)) / 1000;
          actualTime += diff;

          // console.log("time", z , "diff",diff);
          var displacment = GpsDistance(VehicleDataList[i - 1].gpsData, VehicleDataList[i].gpsData);
          // console.log("displacment", displacment);
          speed = displacment * 3600 / (diff);

          //  console.log("speed", i);


          distance += displacment;

          if (speed > 1) {

            // moment(moment.utc(VehicleDataList[i].timestamp).toDate()).local().format('YYYY-MM-DD HH:mm:ss')
            asd.push({
              "time": moment(moment.utc(VehicleDataList[i].timestamp).toDate()).local().format('YYYY-MM-DD HH:mm:ss'), "pre_time": moment(moment.utc(VehicleDataList[i - 1].timestamp).toDate()).local().format('YYYY-MM-DD HH:mm:ss'),
              "diff": diff, "displacment": displacment, "speed": speed
            });
            lable.push(moment(moment.utc(VehicleDataList[i].timestamp).toDate()).local().format('YYYY-MM-DD HH:mm:ss'));
            speedarray.push(speed);
            background_color.push(colors[i % 5]);
            border_color.push(bordercolors[i % 5])
          }


          // console.log("distance", distance);


        }

        //	 prevGpsData = VehicleDataList[i].gpsData;
        //  prevTimestamp = VehicleDataList[i].timestamp;

      }

      $scope.speedDetails = asd;

      $scope.distance = distance;
      $scope.diff = actualTime / 3600;

      $scope.speed = $scope.distance / $scope.diff;
      $scope.show_speed_details = true;
      // console.log("distance", z/3600);
      // console.log("distance",distance);

      var ctx = document.getElementById("myChart").getContext('2d');

      myChart = new Chart(ctx, {
        type: 'line',
        data: {
          labels: lable,
          datasets: [{
            label: '#',
            data: speedarray,
            backgroundColor: background_color,
            borderColor: border_color,
            borderWidth: 1
          }]
        },
        options: {
          scales: {
            yAxes: [{
              ticks: {
                beginAtZero: true
              }
            }]
          }
        }
      });

      return distance;

    }


    function GpsDistance(prevGpsData, gpsData) {
      var gpsDistance = 0

      if (prevGpsData.fixStatus != 0 && gpsData.fixStatus != 0)

        gpsDistance = MathDistance(prevGpsData.latitude, prevGpsData.longitude,
          gpsData.latitude, gpsData.longitude);


      return gpsDistance;

    }


    function MathDistance(lat1, lon1, lat2, lon2) {
      // console.log(lat1, lon1, lat2, lon2);
      var EARTH_RADIUS = 6371; // Km

      var r_lat1 = Math.PI * lat1 / 180
      var r_lat2 = Math.PI * lat2 / 180
      var r_lon1 = Math.PI * lon1 / 180
      var r_lon2 = Math.PI * lon2 / 180


      distance = Math.acos(Math.sin(r_lat1) * Math.sin(r_lat2) + Math.cos(r_lat1)
        * Math.cos(r_lat2) * Math.cos(r_lon2 - r_lon1))
        * EARTH_RADIUS;
      //console.log(distance);
      return isNaN(distance) ? 0.0 : distance;

    }

  });
