<?php
$form = $this->beginWidget('bootstrap.widgets.TbActiveForm', array(
    'id' => 'leave-form',
    'enableAjaxValidation' => false,
        ));
?>

<p class="help-block">Fields with <span class="required">*</span> are required.</p>
<div class="portlet box yellow">
<?php echo $form->errorSummary($model); ?>
    <div class="portlet-title">
        <div class="caption">
            <i class="icon-reorder"></i>
        </div>
        <div class="tools">
            <a href="#" class="collapse"></a>
            <a href="#portlet-config" data-toggle="modal" class="config"></a>
            <a href="#" class="reload"></a>
            <a href="#" class="remove"></a>
        </div>
    </div>
    <div class="portlet-body form">
        <form role="form">
            <div class="form-body">
                <div class="row">
                    <div class="form-group col-md-6">
                     <?php echo $form->dropDownListRow($model, 'EmoloyeeId', Employee::getList(), array('class' => 'form-control')); ?>
                    </div>

                    <div class="form-group col-md-6">
                        <div class="input-group date date date-picker" data-date-format="yyyy-mm-dd">  
                           <?php echo $form->textFieldRow($model, 'StartDate', array('class' => 'form-control')); ?>
                            <span class="input-group-btn" style="padding-top: 25px;">
                                <button class="btn default date-set" type="button"><i class="icon-calendar"></i></button>
                            </span>
                        </div>                    
                    </div>
                </div>
                <div class="row">
                    <div class="form-group col-md-6">
                     <?php echo $form->textFieldRow($model, 'No_of_Day', array('class' => 'form-control')); ?>
                    </div>

                    <div class="form-group col-md-6">
                     <?php echo $form->dropDownListRow($model, 'LeaveType', Leavetype::getList(), array('class' => 'form-control')); ?>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group col-md-6">
                     <?php echo $form->dropDownListRow($model, 'PaidType', array('' => '', 'Pay' => 'Pay', 'NO Pay' => 'No Pay'), array('class' => 'form-control', 'maxlength' => 50)); ?>
                    </div>

                    <div class="form-group col-md-6">
                     <?php echo $form->textAreaRow($model, 'Reason', array('class' => 'form-control', 'maxlength' => 250)); ?>
                    </div>
                </div>           

                <div class="form-group" style="display: none">
                  <?php echo $form->textFieldRow($model, 'CreatedBy', array('value' => Yii::app()->user->id, 'class' => 'form-control')); ?>
                </div>
            </div>
            <div class="form-actions">
                <?php
                $this->widget('bootstrap.widgets.TbButton', array(
                    'buttonType' => 'submit',
                    'type' => 'primary',
                    'label' => $model->isNewRecord ? 'Create' : 'Save',
                    'htmlOptions' => array('class' => 'btn yellow'),
                ));
                ?>
            </div>
        </form>
    </div>
</div>

<?php $this->endWidget(); ?>
