<?php
/* @var $this CController */
$this->menu = array();

$index = array(
    'label'=>Yii::t('site', 'List'),
    'icon'=>'list',
    'url'=>array('admin'),
    'active'=>true,
);

$view = array(
    'label'=>Yii::t('site', 'View'),
    'icon'=>'eye-open',
    'url'=>array('view', 'id'=>!empty($model->id) ? $model->id : 0),
    'active'=>true,
);

$create = array(
    'label'=>Yii::t('site', 'Create'),
    'icon'=>'plus',
    'url'=>array('create'),
    'active'=>true,
);

$update = array(
    'label'=>Yii::t('site', 'Update'),
    'icon'=>'pencil',
    'url'=>array('update', 'id'=>!empty($model->id) ? $model->id : 0),
    'active'=>true,
);

$delete = array(
    'label'=>Yii::t('site', 'Delete'),
    'icon'=>'trash',
    'url'=>'#',
    'linkOptions'=>array(
        'submit'=>array('delete', 'id'=>!empty($model->id) ? $model->id : 0),
        'confirm'=>Yii::t('site', 'Are you sure you want to delete this item?'),
    ),
    'active'=>true,
);

$admin = array(
    'label'=>Yii::t('site', 'Manage'),
    'icon'=>'th',
    'url'=>array('admin'),
    'active'=>true,
);

$search = array(
    'label'=>Yii::t('site', 'Search'),
    'icon'=>'search',
    'url'=>'#',
    'linkOptions'=>array(
        'class'=>'search-button',
    ),
    'active'=>true,
);

switch ($this->action->id) {
    case 'index':
        $this->menu = array($create, $admin);
        break;
    case 'view':
        $this->menu = array($index, $create, $update, $delete, $admin);
        break;
    case 'create':
        $this->menu = array($index, $admin);
        break;
    case 'update':
        $this->menu = array($index, $create, $view, $delete, $admin);
        break;
    case 'admin':
        $this->menu = array($index, $create, $search);
        break;
}