<?php
$form = $this->beginWidget('bootstrap.widgets.TbActiveForm', array(
    'id' => 'holydays-form',
    'enableAjaxValidation' => false,
        ));
?>

<p class="help-block">Fields with <span class="required">*</span> are required.</p>
<div class="portlet box yellow">
    <?php echo $form->errorSummary($model); ?>
    <div class="portlet-title">
        <div class="caption">
            <i class="icon-reorder"></i>
        </div>
        <div class="tools">
            <a href="#" class="collapse"></a>
            <a href="#portlet-config" data-toggle="modal" class="config"></a>
            <a href="#" class="reload"></a>
            <a href="#" class="remove"></a>
        </div>
    </div>
    <div class="portlet-body form">
        <form role="form">
            <div class="form-body">
                <div class="row">
                    <div class="form-group col-md-3">
                        <?php echo $form->labelEx($model, 'Is Public'); ?><br>
                        <?php echo $form->checkBox($model, 'Is_Public', array('value' => 'PUBLIC', 'uncheckValue' => '')); ?>
                        <?php echo $form->error($model, 'Is_Public'); ?>
                    </div>
                    <div class="form-group col-md-3">
                        <?php echo $form->labelEx($model, 'Is Bank'); ?><br>
                        <?php echo $form->checkBox($model, 'Is_Bank', array('value' => 'BANK', 'uncheckValue' => '')); ?>
                        <?php echo $form->error($model, 'Is_Bank'); ?>
                    </div>
                    <div class="form-group col-md-3">  
                        <?php echo $form->labelEx($model, 'Is Mercantile'); ?><br>
                        <?php echo $form->checkBox($model, 'Is_Mercantile', array('value' => 'MERCANTILE', 'uncheckValue' => '')); ?>
                        <?php echo $form->error($model, 'Is_Mercantile'); ?>
                    </div>
                    <div class="form-group col-md-3">  
                        <?php echo $form->labelEx($model, 'Is Poya Day'); ?><br>
                        <?php echo $form->checkBox($model, 'Is_Poyaday', array('value' => 'POYADAY', 'uncheckValue' => '')); ?>
                        <?php echo $form->error($model, 'Is_Poyaday'); ?>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group col-md-6">
                        <div class="input-group date date date-picker" data-date-format="yyyy-mm-dd">  
                            <?php echo $form->textFieldRow($model, 'Date', array('class' => 'form-control')); ?>
                            <span class="input-group-btn" style="padding-top: 25px;">
                                <button class="btn default date-set" type="button"><i class="icon-calendar"></i></button>
                            </span>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <?php echo $form->textFieldRow($model, 'WorkingRate', array('class' => 'form-control', 'maxlength' => 9)); ?>
                    </div>
                </div>
                <div class="row">   
                    <div class="form-group col-md-6">
                        <?php echo $form->textFieldRow($model, 'NOTRate', array('class' => 'form-control', 'maxlength' => 9)); ?>
                    </div>
                    <div class="form-group col-md-6">
                        <?php echo $form->textFieldRow($model, 'DOTRate', array('class' => 'form-control', 'maxlength' => 9)); ?>
                    </div>
                </div>
                <div class="row"> 
                    <div class="form-group col-md-6">
                        <?php echo $form->textAreaRow($model, 'Description', array('class' => 'form-control', 'maxlength' => 250)); ?>
                    </div>                
                </div>
            </div>
            <div class="form-actions">
                <?php
                $this->widget('bootstrap.widgets.TbButton', array(
                    'buttonType' => 'submit',
                    'type' => 'primary',
                    'label' => $model->isNewRecord ? 'Create' : 'Save',
                    'htmlOptions' => array('class' => 'btn yellow'),
                ));
                ?>
            </div>
        </form>
    </div>
</div>

<?php $this->endWidget(); ?>
