<script type="text/javascript">
   

    $( document ).ready(function() {
        $("#alertBox").hide();
    });
   
    function designationonchang(designation) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl('designationsalary/SalaryByDesignation'); ?>',
            data: { Designation : designation },
            dataType: 'json',
            success: function (result) {
                $("#alertBox").show();
                $('#DesignationSalary_MonthlySalary').val(result.MonthlySalary);
                $('#DesignationSalary_DailySalary').val(result.DailySalary);
                $("#tblEmployees tbody").remove();

                var tbody = $("<tbody />"),tr;

                if(result.employees.length == 0 ){
                    $("#alertBox").hide();
                }

                $.each(result.employees,function(_,obj) {
                    tr = $("<tr/>");
                    $.each(obj,function(_,text) {
                        tr.append("<td>"+text+"</td>");
                    });
                    tr.append('<td><input name="employees[]"  type="checkbox" checked value="'+obj.nic+'" class="flat-red"></td>');
                    tr.appendTo(tbody);
                });
                tbody.appendTo("#tblEmployees");
            },
            error: function (data) {
                $("#alertBox").hide();
            }
        });
    }
</script>

<?php
$form = $this->beginWidget('bootstrap.widgets.TbActiveForm', array(
    'id' => 'designation-salary-form',
    'enableAjaxValidation' => false,
        ));
?>
 <div class=" form">
        <form role="form">
            <div class="form-body">
            <p class="help-block">Fields with <span class="required">*</span> are required.</p>
            <div class="well">
                            <div class="row">
                                <div class="form-group col-md-5">
                                <?php echo $form->dropDownListRow($model, 'DesignationId', Designation::getList(), array('onChange' => 'javascript:designationonchang(this.value)', 'class' => 'form-control')); ?>
                                </div>
                                <div class="form-group col-md-3">
                                <?php echo $form->textFieldRow($model, 'MonthlySalary', array('class' => 'form-control', 'maxlength' => 10)); ?>
                                </div>
                                <div class="form-group col-md-3">
                                <?php echo $form->textFieldRow($model, 'DailySalary', array('class' => 'form-control', 'maxlength' => 10)); ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group form-group col-md-3" style="display: none">
                                <?php echo $form->textFieldRow($model, 'Siteid', array('value' => Yii::app()->user->data()->SiteId,'class' => 'form-control')); ?>
                                </div>
                            </div>
                            <div class="form-group col-md-5" style="display: none">
                                <?php echo $form->textFieldRow($model, 'CreatedBy', array('value' => Yii::app()->user->id, 'class' => 'form-control')); ?>
                            </div> 
                        </div>
                        <div class="well">
                            <div id="alertBox" class="alert alert-danger">
                                <h4><i class="icon fa fa-ban"></i> Alert!</h4>
                                 If you change the selected designation salary, salaries of the below employees will be changed.
                            </div>
                            <div id="employees">
                                <table id="tblEmployees" class="table">
                                    <thead>
                                        <tr>
                                            <th>NIC</th>
                                            <th>Name</th>
                                            <th>#</th>
                                        </tr>
                                    </thead>
                                    
                                    <tbody>
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div>
                            <?php
                            $this->widget('bootstrap.widgets.TbButton', array(
                                'buttonType' => 'submit',
                                'type' => 'primary',
                                'label' => $model->isNewRecord ? 'Create' : 'Save',
                                'htmlOptions' => array('class' => 'btn yellow'),
                            ));
                            ?>
                    
            </div>
            
            </div>
        </form>
    </div>
<?php $this->endWidget(); ?>


