<?php

if (!isset($model))
    $model = new YumUserLogin();

$module = Yum::module();

$this->pageTitle = Yum::t('Login');
if (isset($this->title))
    $this->title = Yum::t('Login');
$this->breadcrumbs = array(Yum::t('Login'));

Yum::renderFlash();
?>

<div class="login-form">
     <?php echo CHtml::beginForm(array('//user/auth/login')); ?>
     <?
    if (isset($_GET['action']))
        echo CHtml::hiddenField('returnUrl', urldecode($_GET['action']));
    ?>

    <?php echo CHtml::errorSummary($model); ?>
    <h3 class="form-title">Login to your account</h3>
    <div class="alert alert-error hide">
        <button class="close" data-dismiss="alert"></button>
        <span>Enter any username and password.</span>
    </div>
    <div class="form-group">
        <!--ie8, ie9 does not support html5 placeholder, so we just show field title for that-->
        <label class="control-label visible-ie8 visible-ie9">Username</label>
        <div class="input-icon">
            <i class="icon-user"></i>
            <?php echo CHtml::activeTextField($model, 'username', array('class' => 'form-control placeholder-no-fix', 'placeholder' => 'Username')) ?>
        </div>
    </div>
    <div class="form-group">
        <label class="control-label visible-ie8 visible-ie9">Password</label>
        <div class="input-icon">
            <i class="icon-lock"></i>
             <?php
            echo CHtml::activePasswordField($model, 'password', array('class' => 'form-control placeholder-no-fix', 'placeholder' => 'Password'));
            if ($module->loginType & UserModule::LOGIN_BY_OPENID)
                echo '<br />' . Yum::t('When logging in with OpenID, password can be omitted');
            ?>
        </div>
    </div>
    <div class="form-actions">
        <label class="checkbox">
            <input type="checkbox" name="remember" value="1"/> Remember me
        </label>
        <button type="submit" class="btn green pull-right">
            Login <i class="m-icon-swapright m-icon-white"></i>
        </button>            
    </div>
    <div class="forget-password">
        <h4>Forgot your password ?</h4>
        <p>
            no worries, click <a href="javascript:;"  id="forget-password">here</a>
            to reset your password.
        </p>
    </div>
</div>