

<?php
$form = $this->beginWidget('bootstrap.widgets.TbActiveForm', array(
    'id' => 'area-user',
    'enableAjaxValidation' => false,
        ));
?>

<p class="help-block">Fields with <span class="required">*</span> are required.</p>

<div class="portlet box blue">
<?php echo $form->errorSummary($model); ?>
    <div class="portlet-title">
        <div class="caption">
            <i class="icon-reorder"></i>
        </div>
        <div class="tools">
            <a href="#" class="collapse"></a>
            <a href="#portlet-config" data-toggle="modal" class="config"></a>
            <a href="#" class="reload"></a>
            <a href="#" class="remove"></a>
        </div>
    </div>
    <div class="portlet-body form">
        <form role="form">
            <div class="form-body">
                <div class="form-group">
                    <?php
                    echo $form->labelEx($model, 'superuser');
                    echo $form->dropDownList($model, 'superuser', YumUser::itemAlias('AdminStatus'),array('class'=>'form-control'));
                    echo $form->error($model, 'superuser');
                    ?>
                </div>

                <div class="form-group">
                <?php
                echo $form->labelEx($model, 'status');
                echo $form->dropDownList($model, 'status', YumUser::itemAlias('UserStatus'),array('class'=>'form-control'));
                echo $form->error($model, 'status');
                ?>
                </div>
                    <?php
                    if (Yum::hasModule('role')) {
                        Yii::import('application.modules.role.models.*');
                        ?>
                    <div class="form-group">
                        <p> <?php echo Yum::t('User belongs to these roles'); ?> </p>

                    <?php
                    $this->widget('YumModule.components.Relation', array(
                        'model' => $model,
                        'relation' => 'roles',
                        'style' => 'dropdownlist',
                        'fields' => 'title',
                        'showAddButton' => false
                    ));
                    ?>
                    </div>
                    <?php } ?>

         

            <div class="form-group">
                    <?php
                    echo $form->labelEx($model, 'username');
                    echo $form->textField($model, 'username',array('class'=>'form-control'));
                    echo $form->error($model, 'username');
                    ?>
            </div>


            <div class="form-group">
                <p> Leave password <em> empty </em> to 
                <?php
                echo $model->isNewRecord ? 'generate a random Password' : 'keep it <em> unchanged </em>';
                ?> </p>
<?php $this->renderPartial('/user/passwordfields', array(
    'form' => $passwordform));
?>
            </div>
<?php
if (Yum::hasModule('profile'))
    $this->renderPartial('application.modules.profile.views.profile._form', array(
        'profile' => $profile));
?>

            <div class="form-group">
 <?php $this->widget('bootstrap.widgets.TbButton', array(
			'buttonType'=>'submit',
			'type'=>'primary',
			'label'=>$model->isNewRecord ? 'Create' : 'Save',
		)); ?>
            </div>

<?php $this->endWidget(); ?>

        </form>
    </div>
</div>
