<?php

Yii::import('application.modules.user.controllers.YumController');
class YumUserController extends YumController {
	public $defaultAction = 'login';

	public function accessRules() {
		return array(
				array('allow',
					'actions'=>array('index', 'view', 'login','GetUserNames','GetUserDetails'),
					'users'=>array('*'),
					),
				array('allow',
					'actions'=>array('profile', 'logout', 'changepassword', 'passwordexpired', 'delete', 'browse'),
					'users'=>array('@'),
					),
				array('allow',
					'actions'=>array('admin','delete','create','update', 'list', 'assign', 'generateData', 'csv','createwizard','ResetPassword'),
					'expression' => 'Yii::app()->user->isAdmin()'
					),
				array('allow',
					'actions'=>array('create'),
					'expression' => 'Yii::app()->user->can("user_create")'
					),
				array('allow',
					'actions'=>array('admin'),
					'expression' => 'Yii::app()->user->can("user_admin")'
					),
				array('deny',  // deny all other users
						'users'=>array('*'),
						),
				);
	}

	public function actionResetPassword() {
        $model = $this->loadUser();
        $passwordform = new YumUserChangePassword();

        if (true) {
            // Password change is requested ?
            if (isset($_POST['YumUserChangePassword']) && $_POST['YumUserChangePassword']['password'] != '') {
                $model->salt = YumEncrypt::generateSalt();
                $passwordform->attributes = $_POST['YumUserChangePassword'];
                if ($passwordform->validate()) {
                    $model->setPassword($_POST['YumUserChangePassword']['password'], $model->salt);
                    if (!$passwordform->hasErrors() && $model->save()) {
                        Yum::setFlash('The password has been reset');
                        $this->redirect(array('//user/user/view', 'id' => $model->id));
                    }
                }
            }
        }

        $this->render('_resetpassword', array(
            'model' => $model,
            'passwordform' => $passwordform,
            'profile' => isset($profile) ? $profile : false,
        ));
    }

	public function actionGenerateData() {
		if(Yum::hasModule('role'))
			Yii::import('application.modules.role.models.*');
		if(isset($_POST['user_amount'])) {
			for($i = 0; $i < $_POST['user_amount']; $i++) {
				$user = new YumUser();
				$user->username = sprintf('Demo_%d_%d', rand(1, 50000), $i);
				$user->roles = array($_POST['role']);
				$user->salt = YumEncrypt::generateSalt();
				$user->password = YumEncrypt::encrypt($_POST['password'], $user->salt);
				$user->createtime = time();
				$user->status = $_POST['status'];

				if($user->save()) {
					if(Yum::hasModule('profile')) {
						$profile = new YumProfile();
						$profile->user_id = $user->id;
						$profile->timestamp = time();
						$profile->firstname = $user->username;
						$profile->lastname = $user->username;
						$profile->privacy = 'protected';
						$profile->email = 'e@mail.de';
						$profile->save();
					} 
				}
			}
		}
		$this->render('generate_data');
	}

	public function actionIndex() {
		// If the user is not logged in, so we redirect to the actionLogin,
		// which will render the login Form

		if(Yii::app()->user->isGuest)
			$this->actionLogin();
		else
			$this->actionList();
	}

	public function actionStats() {
		$this->redirect($this->createUrl('/user/statistics/index'));
	}

	public function actionPasswordExpired()
	{
		$this->actionChangePassword($expired = true);
	}

	public function actionLogin() {
		// Do not show the login form if a session expires but a ajax request
		// is still 
            //$this->layoutPath = Yii::getPathOfAlias('user.views.layouts');
            //$this->layout = 'main';
            //$this->layout = 'login';
            
		if(Yii::app()->user->isGuest && Yii::app()->request->isAjaxRequest)
			return false;
		$this->redirect(array('/user/auth'));
	}

	public function actionLogout() {
		$this->redirect(array('//user/auth/logout'));
	}

	public function beforeAction($event) {
		if(!Yii::app()->user instanceof YumWebUser)
			throw new CException(Yum::t('Please make sure that Yii uses the YumWebUser component instead of CWebUser in your config/main.php components section. Please see the installation instructions.'));
		if (Yii::app()->user->isAdmin())
			$this->layout = Yum::module()->adminLayout;
		else
			$this->layout = Yum::module()->layout;
		return parent::beforeAction($event);
	}

	/**
	 * Change password
	 */
	public function actionChangePassword($expired = false) {
		$id = Yii::app()->user->id;

		$user = YumUser::model()->findByPk($id);
		if(!$user)
			throw new CHttpException(403, Yum::t('User can not be found'));
		else if($user->status <= 0)
			throw new CHttpException(404, Yum::t('User is not active'));

		$form = new YumUserChangePassword;
		$form->scenario = 'user_request';

		if(isset($_POST['YumUserChangePassword'])) {
			$form->attributes = $_POST['YumUserChangePassword'];
			$form->validate();

			if(!YumEncrypt::validate_password($form->currentPassword,
						YumUser::model()->findByPk($id)->password,
						YumUser::model()->findByPk($id)->salt))
				$form->addError('currentPassword',
						Yum::t('Your current password is not correct'));

			if(!$form->hasErrors()) {
				if(YumUser::model()->findByPk($id)->setPassword($form->password,
							YumUser::model()->findByPk($id)->salt)) {
					Yum::setFlash('The new password has been saved');
					Yum::log(Yum::t('User {username} has changed his password', array(
									'{username}' => Yii::app()->user->name)));
				}
				else  {
					Yum::setFlash('There was an error saving the password');
					Yum::log( Yum::t(
								'User {username} tried to change his password, but an error occured', array(
									'{username}' => Yii::app()->user->name)), 'error');
				}

				$this->redirect(Yum::module()->returnUrl);
			}
		}

		if(Yii::app()->request->isAjaxRequest)
			$this->renderPartial('changepassword', array(
						'form'=>$form,
						'expired' => $expired));
		else
			$this->render('changepassword', array(
						'form'=>$form,
						'expired' => $expired));
	}

	// Redirects the user to the specified profile
	// if no profile is specified, redirect to the own profile
	public function actionProfile($id = null) {
		$this->redirect(array('//profile/profile/view',
					'id' => $id ? $id : Yii::app()->user->id));
	}

	public $nfcs;
	public $actives;

	/**
	 * Displays a User
	 */
	public function actionView()
	{
		$model = $this->loadUser();
        /*$models = Usernfccards::model()->findAll(array(
            'condition' => 'userId = :id',
            'params' => array(':id' => $model->id,),
        ));
        $this->render('view',array(
					'model'=>$model,
                    'models'=>$models,
					));*/
					
		 //$userNfc = Usernfccards::model()->findByAttributes(array('userId' => $model->id));

		 $nfcs ="";
		 $actives = "";
		 
        /*if(!empty($userNfc)){
            $nfcs = Nfc::model()->findAllByAttributes(
                    array(
                        'card_id' => $userNfc->card_id,
                ));
            $actives = Activerfid::model()->findAllByAttributes(
                array(
                    'card_id' => $userNfc->card_id,
            ));
            
        }*/
        
        $this->render('view',array(
					'model'=>$model,
                    'nfcs'=>$nfcs,
                    'actives' => $actives
					));
	}

	/**
	 * Creates a new User.
	 */
	public function actionCreate() {
		$model = new YumUser;
		if(Yum::hasModule('profile'))
			$profile = new YumProfile;
		$passwordform = new YumUserChangePassword;

		// When opening a empty user creation mask, we most probably want to
		// insert an _active_ user
		if(!isset($model->status))
			$model->status = 1;

		if(isset($_POST['YumUser'])) {
			$model->salt = YumEncrypt::generateSalt();
			$model->attributes=$_POST['YumUser'];
			
			if(Yum::hasModule('role'))
				$model->roles = Relation::retrieveValues($_POST);

			if(Yum::hasModule('profile') && isset($_POST['YumProfile']) )
				$profile->attributes = $_POST['YumProfile'];

			if(isset($_POST['YumUserChangePassword'])) {
				if($_POST['YumUserChangePassword']['password'] == '') {
					$password = YumUser::generatePassword();
					$model->setPassword($password, $model->salt);
					Yum::setFlash(Yum::t('The generated Password is {password}', array(
									'{password}' => $password)));
				} else {
					$passwordform->attributes = $_POST['YumUserChangePassword'];

					if($passwordform->validate())
						$model->setPassword($_POST['YumUserChangePassword']['password'], $model->salt);
				}
			}

			$model->activationKey = YumEncrypt::encrypt(microtime() . $model->password, $model->salt);

			if($model->username == '' && isset($profile))
				$model->username = $profile->email;

			$model->validate();

			if(isset($profile))
				$profile->validate();

			if(!$model->hasErrors()
					&& !$passwordform->hasErrors()) {
				$model->save();
				if(isset($profile)) {
					$profile->user_id = $model->id;
					$profile->save(array('user_id'), false);
				}
				$this->redirect(array('view', 'id'=>$model->id));
			}
		}

		$this->render('create',array(
					'model' => $model,
					'passwordform' => $passwordform,
					'profile' => isset($profile) ? $profile : null,
					));
	}

    public function actionCreateWizard() {
        $model = new YumUser;
	$profile = new YumProfile;

        if(isset($_POST['YumUser'])) {
				$model = new YumUser;
			
                
                //$model->username = $data[0]['samaccountname'];
				$model->attributes=$_POST['YumUser'];
				$model->businessUnitId = 1;
				$model->activationKey = "eimsky";
                $model->roles = Relation::retrieveValues($_POST);
				//$data = $this->getAdUserByUsername($model->username);
                //$model->superuser = $_POST['superuser'];
                $model->salt = YumEncrypt::generateSalt();
                $model->password = YumEncrypt::encrypt('fms@lion', $model->salt);
                $model->createtime = time();
                //$model->status = $_POST['status'];
                if($model->save())
                {
			 if(Yum::hasModule('profile') && isset($_POST['YumProfile']) ) {
							
						$profile->attributes = $_POST['YumProfile'];
						$profile->user_id = $model->id;
						//$profile->timestamp =  time();
						$profile->save(array('user_id'), false);
                        //$profile->save();
                        $this->redirect(array('view', 'id'=>$model->id));

                    }
                    /*if(Yum::hasModule('profile')) {
                        $profile = new YumProfile;
                        $profile->user_id = $model->id;
                        $profile->timestamp = $model->createtime;
                        $profile->privacy = 'protected';
                        $profile->firstname = $data[0]['givenname'];
                        $profile->lastname = $data[0]['sn'];
						if($data[0]['mail'] == '')
                            $profile->email = 'default@expo.com';
						else
							$profile->email = $data[0]['mail'];
                        $profile->save();
                        $this->redirect(array('view', 'id'=>$model->id));

                    }*/
                }
            }

        $this->render('createwizard',array(
            'model' => $model,
            //'passwordform' => $passwordform,
            'profile' => isset($profile) ? $profile : null,
        ));
    }

	public function actionUpdate() {
		$model = $this->loadUser();
		$passwordform = new YumUserChangePassword();

		if(isset($_POST['YumUser'])) {
			if(!isset($model->salt) || empty($model->salt))
				$model->salt = YumEncrypt::generateSalt();
			
			$model->attributes = $_POST['YumUser'];
			if(Yum::hasModule('role')) {
				Yii::import('application.modules.role.models.*');
				// Assign the roles and belonging Users to the model
				$model->roles = Relation::retrieveValues($_POST);
			}

			if(Yum::hasModule('profile')) {
				$profile = $model->profile;

				if(isset($_POST['YumProfile']) )
					$profile->attributes = $_POST['YumProfile'];
			}

			// Password change is requested ?
			if(isset($_POST['YumUserChangePassword'])
					&& $_POST['YumUserChangePassword']['password'] != '') {
				$passwordform->attributes = $_POST['YumUserChangePassword'];
				if($passwordform->validate())
					$model->setPassword($_POST['YumUserChangePassword']['password'], $model->salt);
			}

			if(!$passwordform->hasErrors() && $model->save()) {
				if(isset($profile)) 
					$profile->save();

				$this->redirect(array('//user/user/view', 'id' => $model->id));
			}
		}

		$this->render('update', array(
					'model'=>$model,
					'passwordform' =>$passwordform,
					'profile' => isset($profile) ? $profile : false,
					));
	}

	/**
	 * Deletes a user by setting the status to 'deleted'
	 */
	public function actionDelete($id = null) {
		if(!$id)
			$id = Yii::app()->user->id;

		$user = YumUser::model()->findByPk($id);

		if(Yii::app()->user->isAdmin()) {
			//This is necesary for handling human stupidity.
			if($user && ($user->id == Yii::app()->user->id)) {
				Yum::setFlash('You can not delete your own admin account');
				$this->redirect(array('//user/user/admin'));
			}

			if($user->delete()) {
				Yum::setFlash('The User has been deleted');
				if(!Yii::app()->request->isAjaxRequest)
					$this->redirect('//user/user/admin');
			}
		} else if(isset($_POST['confirmPassword'])) {
			if(YumEncrypt::validate_password($_POST['confirmPassword'],
						$user->password, $user->salt)) {
				if($user->delete()) {
					Yii::app()->user->logout();
					$this->actionLogout();
				}
				else
					Yum::setFlash('Error while deleting Account. Account was not deleted');
			} else {
				Yum::setFlash('Wrong password confirmation! Account was not deleted');
			}
			$this->redirect(Yum::module()->deleteUrl);
		} 

		$this->render('confirmDeletion', array('model' => $user));
	}

	public function actionBrowse() {
		$search = '';
		if(isset($_POST['search_username']))
			$search = $_POST['search_username'];

		$criteria = new CDbCriteria;

		/*		if(Yum::hasModule('profile')) {
					$criteria->join = 'LEFT JOIN '.Yum::module('profile')->privacysettingTable .' on t.id = privacysetting.user_id';
					$criteria->addCondition('appear_in_search = 1'); 
					} */

		$criteria->addCondition('status = 1 or status = 2 or status = 3');
		if($search) 
			$criteria->addCondition("username = '{$search}'");

		$dataProvider=new CActiveDataProvider('YumUser', array(
					'criteria' => $criteria, 
					'pagination'=>array(
						'pageSize'=>50,
						)));

		$this->render('browse',array(
					'dataProvider'=>$dataProvider,
					'search_username' => $search ? $search : '',
					));
	}

	public function actionList()
	{
		$dataProvider=new CActiveDataProvider('YumUser', array(
					'pagination'=>array(
						/*'criteria'=>array(
							'condition'=>'status > 0', 
							),*/
						'pageSize'=>Yum::module()->pageSize,
						)));

		$this->render('index',array(
					'dataProvider'=>$dataProvider,
					));
	}

	public function actionAdmin()
	{
		if(Yum::hasModule('role'))
			Yii::import('application.modules.role.models.*');

		$this->layout = Yum::module()->adminLayout;

		$model = new YumUser('search');

		if(isset($_GET['YumUser']))
			$model->attributes = $_GET['YumUser'];

		$this->render('admin', array('model'=>$model));
	}

	/**
	 * Loads the User Object instance
	 * @return YumUser
	 */
	public function loadUser($uid = 0)
	{
		if($this->_model === null)
		{
			if($uid != 0)
				$this->_model = YumUser::model()->findByPk($uid);
			elseif(isset($_GET['id']))
				$this->_model = YumUser::model()->findByPk($_GET['id']);
			if($this->_model === null)
				throw new CHttpException(404,'The requested User does not exist.');
		}
		return $this->_model;
	}

    public function getMembers($group = FALSE, $inclusive = FALSE) {
        // Active Directory server
        $ldap_host = "expo.ad";
		
		try {
      $ldap_dn = "DC=expo,DC=ad";

        // Domain, for purposes of constructing $user
        $ldap_usr_dom = "@" . $ldap_host;

        // Active Directory user
        $user = "cmsAdmin";
        $password = "vid@1359";

        // User attributes we want to keep
        // List of User Object properties:
        // http://www.dotnetactivedirectory.com/Understanding_LDAP_Active_Directory_User_Object_Properties.html
        $keep = array(
            "samaccountname",
            "distinguishedname",
            "mail",
            "sn",
            "givenname"
        );
		
				
        // Connect to AD
        $ldap = ldap_connect($ldap_host) or die("Could not connect to LDAP");
			
         $ldapbind = ldap_bind($ldap, $user . $ldap_usr_dom, $password) or die("Could not bind to LDAP");
		
		 if ($ldapbind) {
				echo "LDAP bind successful...";
		} else {
			echo "LDAP bind failed...";
		}
	
		
		//die;
		
		//$group = new array("Domain Users");
	
        // Begin building query
        if ($group)
            $query = "(&";
        else
            $query = "";

        $query .= "(&(objectClass=user)(objectCategory=person))";
        
        //$query ="((samaccountname=lasitha.kumara))";

        // Filter by memberOf, if group is set
        if (is_array($group)) {
            // Looking for a members amongst multiple groups
            if ($inclusive) {
                // Inclusive - get users that are in any of the groups
                // Add OR operator
                $query .= "(|";
            } else {
                // Exclusive - only get users that are in all of the groups
                // Add AND operator
                $query .= "(&";
            }

            // Append each group
            foreach ($group as $g)
                $query .= "(memberOf=CN=$g,$ldap_dn)";

            $query .= ")";
        } elseif ($group) {
            // Just looking for membership of one group
            $query .= "(memberOf=CN=$group,$ldap_dn)";
        }      
        
        // Close query
        if ($group)
            $query .= ")";
        else
            $query .= "";

        
        
        // Uncomment to output queries onto page for debugging
       //print_r($query);
       // die;
        // Search AD

        $query = '(&(CN=*))';

        $results = ldap_search($ldap, $ldap_dn, $query);

		//print_r($results);
		//die;

        $entries = ldap_get_entries($ldap, $results);

		//die;

        // Remove first entry (it's always blank)
        array_shift($entries);

        $output = array(); // Declare the output array

        $i = 0; // Counter
        // Build output array
        foreach ($entries as $u) {
            foreach ($keep as $x) {
                // Check for attribute
                if (isset($u[$x][0]))
                    $attrval = $u[$x][0];
                else
                    $attrval = NULL;

                // Append attribute to output array
                $output[$i][$x] = $attrval;
            }
            $i++;
        }

        return $output;
			} catch (Exception $e) {
				echo 'Caught exception: ',  $e->getMessage(), "\n";
			}
		
        // Active Directory DN
     
    }
    
      public function getAdUserByUsername($username) {
		
        $options = Yii::app()->params['ldap'];
     
        $ldap_host = $options['ldaphost'];
        
        $defaultdomain = $options['defaultDomain'];

        $ldap_dn = $options['ldapdn'];//"DC=expo,DC=ad";

        $ldap_usr_dom = "@" . $ldap_host;

        // Active Directory user
        $user = $options['ldapuser'];//"cmsAdmin";
        $password = $options['ldappassword'];//"vid@1359";
        
        $keep = array(
            "samaccountname",
            "distinguishedname",
            "mail",
            "sn",
            "givenname",
			"userprincipalname"
        );
		//die;
        // Connect to AD
        $ldap = ldap_connect($ldap_host) or die("Could not connect to LDAP");
		ldap_set_option($ldap, LDAP_OPT_PROTOCOL_VERSION, 3);
        ldap_set_option($ldap, LDAP_OPT_REFERRALS, 0);
        ldap_bind($ldap, $defaultdomain."\\".$user, $password) or die("Could not bind to LDAP");

		//die;
		
        //$query = "(samaccountname=".$user.")";
		 $filter='(sAMAccountName='.$username.')';
        
        //$query ="((samaccountname=lasitha.kumara))";

        $results = ldap_search($ldap, $ldap_dn, $filter);


        $entries = ldap_get_entries($ldap, $results);


        // Remove first entry (it's always blank)
        array_shift($entries);
		
		//print_r($entries);
		//die;

        $output = array(); // Declare the output array

        $i = 0; // Counter
        // Build output array
        foreach ($entries as $u) {
            foreach ($keep as $x) {
                // Check for attribute
                if (isset($u[$x][0]))
                    $attrval = $u[$x][0];
                else
                    $attrval = NULL;

                // Append attribute to output array
                $output[$i][$x] = $attrval;
            }
            $i++;
        }

        return $output;
    }


    public function actionGetUserNames() {
		//echo 'sdfsdf';
		//die;
        //$account_id = $_POST['accountId'];
        //$data = $this->getMembers();
		//print_r( $data);
		//die;
		//$data = $this->getAdUserByUsername('cafeUser02');
		//print_r($data);
		//die;
		
        $list = CHtml::listData($data, 'samaccountname', 'samaccountname');
        echo ' <select name="user[]" class="multi-select" multiple="" id="User_names" >';
        foreach ($list as $value => $name) {
            echo CHtml::tag('option', array('value' => $value), CHtml::encode($name), true);
        }
        echo '</select>';
             
        die;
    }
	
	public function actionGetUserDetails() {
        //echo "one";
        //die;
        $username = $_POST['user_name'];
        //$username = 'irshard';
        $data = $this->getAdUserByUsername($username);
		$uname = $data[0]['samaccountname'];
		$fname = $data[0]['givenname'];
		$lname = $data[0]['sn'];
		$mail = $data[0]['mail'];
		//print_r($data[0]['sn']);
		//die;
        //$list = CHtml::listData($data, 'id', 'platenumber');
		
		//echo $fname . $uname . $lname . $mail ;
        echo ' <h4 class="form-section">User Details</h4>
                                    <div class="col-md-8">
                                        <p class="form-control-static" data-display="">User Name : '.$uname.'<br></p>
                                    </div>
									<div class="col-md-8">
                                        <p class="form-control-static" data-display="">First Name : '.$fname.'<br></p>
                                    </div>
									<div class="col-md-8">
                                        <p class="form-control-static" data-display="">Last Name : '.$lname.'<br></p>
                                    </div>
									<div class="col-md-8">
                                        <p class="form-control-static" data-display="">Email : '.$mail.'<br></p>
                                    </div>' ;
                                
        die;
    }

}
