<?

class YumUserIdentity extends CUserIdentity {
	private $id;
	public $user;
	public $facebook_id=null;
	public $facebook_user=null;
	const ERROR_EMAIL_INVALID=3;
	const ERROR_STATUS_INACTIVE=4;
	const ERROR_STATUS_BANNED=5;
	const ERROR_STATUS_REMOVED=6;
	const ERROR_STATUS_USER_DOES_NOT_EXIST=7;

	public function authenticateFacebook() {
		$fbconfig = Yum::module()->facebookConfig;
		if (!$fbconfig || $fbconfig && !is_array($fbconfig))
			throw new Exception('actionLogout for Facebook was called, but is not activated in application configuration');

		Yii::import('application.modules.user.vendors.facebook.*');
		require_once('Facebook.php');
		$facebook = new Facebook($fbconfig);

		$fb_uid = $facebook->getUser();
		$profile = YumProfile::model()->findByAttributes(array('facebook_id'=>$fb_uid));
		$user = ($profile) ? YumUser::model()->findByPk($profile->user_id) : null;
		if ($user === null)
			$this->errorCode = self::ERROR_USERNAME_INVALID;
		else if($user->status == YumUser::STATUS_INACTIVE)
			$this->errorCode = self::ERROR_STATUS_INACTIVE;
		else if($user->status == YumUser::STATUS_BANNED)
			$this->errorCode = self::ERROR_STATUS_BANNED;
		else
		{
			$this->id = $user->id;
			$this->username = 'facebook';
			$this->facebook_id = $fb_uid;
			//$this->facebook_user = $facebook->api('/me');
			$this->errorCode = self::ERROR_NONE;
		}
	}

	public $_options;
	public $_domain;
	public $_loginEmail;
	public $_firstName;
	public $_lastName;
	public $_email;
	
	public function authenticateLdap(){

        $this->_options = Yii::app()->params['ldap'];
      
        $username = $this->username;
        $password = $this->password;
        
        if(strpos($username,'@') !== false){
            $this->_loginEmail = $username;
            $exploded = explode('@',$username);
            $this->username = $exploded[0];
        }
	
        $slashPos = strpos($this->username, "\\");
        if($slashPos !== false){
            $this->username = substr($this->username, $slashPos+1);
            $this->_domain = substr($this->username, 0, $slashPos);
        }else{
            $this->_domain = $this->_options['defaultDomain'];
        }
		    

        $this->errorCode = self::ERROR_NONE;

            if($this->username != '' && $this->password != ''){

                $bind = false;
                $connected = false;
                $ldap = false;

                //connect to the first available domain controller in our list
                foreach($this->_options['servers'] AS $server){
                    $ldap = ldap_connect($server);
                    if($ldap !== false){
                        ldap_set_option($ldap, LDAP_OPT_PROTOCOL_VERSION, 3);
                        ldap_set_option($ldap, LDAP_OPT_REFERRALS, 0);
						$connected  = true;
                        //$connected = @ldap_bind($ldap, $this->_options['defaultDomain']."\\".$this->_options['ldapuser'], $this->_options['ldappassword']); //test if we can connect to ldap using anonymous bind
                        if($connected){
                            /*if($this->_loginEmail === false){
                                $ldaprdn = $this->_domain . "\\" . $this->username;
                            }else{


                                $ldaprdn = $this->_loginEmail;
                            }*/
							
							//die;
                            $bind = @ldap_bind($ldap, $this->_options['defaultDomain']."\\".$this->username, $this->password);
                            break; //we connected to one successfully
                        }
                    }
                }		

                //were we able to connect to any domain controller?
                if(!$connected){
					
                    $this->errorCode = self::ERROR_NO_DOMAIN_CONTROLLER_AVAILABLE;

                }else{
				
                    //were we able to authenticate to a domain controller as our user?
                    if ($bind) {
                        //if we can bind to active directory we must have valid AD credentials
                        $filter='(sAMAccountName='.$this->username.')';


                        $conn=array();
                        for($i = 0; $i < count($this->_options['search']); $i++){
                            $conn[] = $ldap;
                        }

                        $results = ldap_search($conn,$this->_options['search'],$filter);
                        $foundInSearch = false;

                        foreach($results AS $result){
                            $info = ldap_get_entries($ldap, $result);
                            if($info['count'] > 0){
								//$this->_firstName = (isset($info['0']['givenname']['0']))?($info['0']['givenname']['0']):('');
								//die;
                                /*$this->_firstName = (isset($info['0']['givenname']['0']))?($info['0']['givenname']['0']):('');
                                $this->_lastName = (isset($info['0']['sn']['0']))?($info['0']['sn']['0']):('');
                                $this->_email = (isset($info['0']['mail']['0']))?($info['0']['mail']['0']):('');

                                $this->_securityGroups = array();
                                foreach($info['0']['memberof'] AS $sg){
                                    preg_match('/CN=(.*?),/',$sg, $matches);
                                    if(isset($matches[1])){
                                        $this->_securityGroups[] = $matches['1'];
                                    }
                                }
                                sort($this->_securityGroups);*/

                                $foundInSearch = true;

                                break;
                            }
                        }
						
						 //$foundInSearch = true;

                        if(!$foundInSearch){
                            $this->errorCode = self::ERROR_PASSWORD_INVALID;
                        }
                    }else{
                        //if we can't bind to active directory it means that the username / password was invalid
                        $this->errorCode = self::ERROR_PASSWORD_INVALID;

                    }
                }
            }else{
                //if username or password is blank don't even try to authenticate
                $this->errorCode = self::ERROR_PASSWORD_INVALID;
            }
		
		//echo $this->errorCode;
					//die;
			
            switch($this->errorCode){
                case self::ERROR_PASSWORD_INVALID :
                    $this->errorMessage = 'Invalid Credentials.';
					
                    break;
                case self::ERROR_NONE :
					
                    $user = YumUser::model()->find('username=:username', array(':username' => $username));
                    $this->id = $user->id;
                    $this->setState('id', $user->id);
                    $this->username = $user->username;
                    $this->user = $user;
                    break;
                default : $this->errorMessage = 'Unable to Authenticate';

            }
            return !$this->errorCode;
	}
	// Authenticate the user. When without_password is set to true, the user
	// gets authenticated without providing a password. This is used for
	// the option 'loginAfterSuccessfulActivation'
	public function authenticate($without_password = false)
	{
		$user = YumUser::model()->find('username = :username', array(
					':username' => $this->username));
	
		
		// try to authenticate via email
		if(!$user && (Yum::module()->loginType & 2) && Yum::hasModule('profile')) {
			if($profile = YumProfile::model()->find('email = :email', array(
							':email' => $this->username)))
				if($profile->user)
					$user = $profile->user;
		}

		if(!$user)
			return self::ERROR_STATUS_USER_DOES_NOT_EXIST;

        /*$this->id = $user->id;
        $this->setState('id', $user->id);
        $this->username = $user->username;
        $this->user = $user;*/

		if($without_password)
			$this->credentialsConfirmed($user);
		if(!YumEncrypt::validate_password($this->password, $user->password, $user->salt))
			$this->errorCode=self::ERROR_PASSWORD_INVALID;
		else if($user->status == YumUser::STATUS_INACTIVE)
			$this->errorCode=self::ERROR_STATUS_INACTIVE;
		else if($user->status == YumUser::STATUS_BANNED)
			$this->errorCode=self::ERROR_STATUS_BANNED;
		else if($user->status == YumUser::STATUS_REMOVED)
			$this->errorCode=self::ERROR_STATUS_REMOVED;
		else
			$this->credentialsConfirmed($user);
		return !$this->errorCode;

	}

	function credentialsConfirmed($user) {
		$this->id = $user->id;
		$this->setState('id', $user->id);
        $this->username = $user->username;
        $this->user = $user;
		$this->errorCode=self::ERROR_NONE;
	}

	/**
	 * @return integer the ID of the user record
	 */
	public function getId()
	{
		return $this->id;
	}

	public function getRoles()
	{
		return $this->Role;
	}

}
