
<?php
$form = $this->beginWidget('bootstrap.widgets.TbActiveForm', array(
    'id' => 'area-role',
    'enableAjaxValidation' => false,
        ));
?>

<p class="help-block">Fields with <span class="required">*</span> are required.</p>

<div class="portlet box yellow">

    <?php echo CHtml::errorSummary($model); ?>

    <div class="portlet-title">
        <div class="caption">
            <i class="icon-reorder"></i>
        </div>
        <div class="tools">
            <a href="#" class="collapse"></a>
            <a href="#portlet-config" data-toggle="modal" class="config"></a>
            <a href="#" class="reload"></a>
            <a href="#" class="remove"></a>
        </div>
    </div>
    <div class="portlet-body form">
        <form role="form">
            <div class="form-body">
                <div class="form-group">
                    <?php echo CHtml::activeLabelEx($model, 'title'); ?>
                    <?php echo CHtml::activeTextField($model, 'title',array('class'=>'form-control'), array('size' => 20, 'maxlength' => 20)); ?>
                    <?php echo CHtml::error($model, 'title'); ?>
                </div>

                <div class="form-group">
                    <?php echo CHtml::activeLabelEx($model, 'description'); ?>
                    <?php echo CHtml::activeTextArea($model, 'description', array('class'=>'form-control'),array('rows' => 6, 'cols' => 50)); ?>
                    <?php echo CHtml::error($model, 'description'); ?>
                </div>	


                <?php if (Yum::hasModule('membership')) { ?>
                    <div class="form-group">
                        <?php echo CHtml::activeLabelEx($model, 'membership_priority'); ?>
                        <?php echo CHtml::activeTextField($model, 'membership_priority',array('class'=>'form-control')); ?>
                        <div class="hint">
                            <?php echo Yum::t('Leave empty or set to 0 to disable membership for this role.'); ?>
                            <?php echo Yum::t('Set to >0 to enable membership for this role and set a priority.'); ?>
                            <?php echo Yum::t('Higher is usually more worthy. This is used to determine downgrade possibilities.'); ?>
                        </div>
                    </div>
                    <div class="form-group">
                        <?php echo CHtml::activeLabelEx($model, 'price'); ?>
                        <?php echo CHtml::activeTextField($model, 'price',array('class'=>'form-control')); ?>
                        <?php echo CHtml::Error($model, 'price'); ?>
                    </div>
                    <div class="hint"> 
                        <?php echo Yum::t('How expensive is a membership? Set to 0 to disable membership for this role'); ?>
                    </div>

                    <div class="form-group">
                        <?php echo CHtml::activeLabelEx($model, 'duration'); ?>
                        <?php echo CHtml::activeTextField($model, 'duration',array('class'=>'form-control')); ?>
                        <?php echo CHtml::Error($model, 'duration'); ?>
                    </div>
                    <div class="hint"> 
                        <?php echo Yum::t('How many days will the membership be valid after payment?'); ?>

                    </div>
                    <div style="clear: both;"> </div>
                <?php } ?>

                <div class="form-group">
                    <?php echo CHtml::label(Yum::t('These users have been assigned to this role'), ''); ?> 

                    <?php
                    $this->widget('YumModule.components.Relation', array(
                        'model' => $model,
                        'relation' => 'users',
                        'style' => 'dropdownlist',
                        'fields' => 'username',
                        'htmlOptions' => array(
                            'checkAll' => Yum::t('Choose All'),
                            'template' => '<div style="float:left;margin-right:5px;">{input}</div>{label}'),
                        'showAddButton' => false
                    ));
                    ?>
                </div>

                <div class="form-group">
                    <?php
                    $this->widget('bootstrap.widgets.TbButton', array(
                        'buttonType' => 'submit',
                        'type' => 'primary',
                        'label' => $model->isNewRecord ? 'Create' : 'Save',
                        'htmlOptions'   => array('class'=>'btn yellow'),
                    ));
                    ?>
                </div>

<?php $this->endWidget(); ?>

        </form>
    </div>
</div>

