<?php

Yii::import('application.modules.user.controllers.YumController');
Yii::import('application.modules.user.models.*');
Yii::import('application.modules.role.models.*');

class YumPermissionController extends YumController
{
	public $defaultAction = 'admin';

	public function accessRules()
	{
		return array(
				array('allow',
					'actions'=>array('admin', 'create', 'index', 'delete','CreateUserPermission','GetAllPermissionByUser'),
					'users'=>array('admin','cmsAdmin')
					),
				array('deny',  // deny all other users
					'users'=>array('*'),
					),
				);
	}

	//test Commit

	public function actionIndex() {
		$this->render('view', array(
					'actions' => YumAction::model()->findAll()));
	}

	public function actionDelete() {
		$permission = YumPermission::model()->findByPk($_GET['id']);
		if($permission->delete())
			Yum::setFlash(Yum::t('The permission has been removed'));
		else
			Yum::setFlash(Yum::t('Error while removing the permission'));
	
		$this->redirect(array('//role/permission/admin')); 
	}

	public function actionAdmin()
	{
		$this->layout = Yum::module('role')->layout;
		$model=new YumPermission('search');
		$model->unsetAttributes();  

		if(isset($_GET['YumPermission']))
			$model->attributes=$_GET['YumPermission'];

		$this->render('admin',array(
					'model'=>$model,
					));
	}

	public function actionCreate() {
		$this->layout = Yum::module()->adminLayout;
		$model = new YumPermission;
                
                
		$this->performAjaxValidation($model, 'permission-create-form');

		if(isset($_POST['YumPermission'])) {
			$model->attributes=$_POST['YumPermission'];
			if($model->validate()) {
				if($_POST['YumPermission']['type'] == 'user')  {
					$model->subordinate = 1;//$_POST['YumPermission']['subordinate_id'];
					$model->principal = $_POST['YumPermission']['principal_id'];
				} else if($_POST['YumPermission']['type'] == 'role')  {
					$model->subordinate_role = 1;//$_POST['YumPermission']['subordinate_id'];
					$model->principal_role = $_POST['YumPermission']['principal_id'];
				}
				if($model->save())
					$this->redirect(array('admin'));
				return;
			}
		}
		$model->type = 'user'; // preselect 'user'
		$users  = YumUser::model()->findAllByAttributes(array("status"=> 1 ));
		$roles  = YumRole::model()->findAll();
		$this->render('create',array('model'=>$model,'users'=> $users,'roles'=> $roles ));

	}

	public function actionGetAllPermissionByUser(){
		
		$userId = $_POST["UserId"];
		
        $userPermissions = YumPermission::model()->findAllByAttributes(array("principal_id"=>$userId, "type"=>"user"));
		if(!empty($userPermissions)){
			echo CJSON::encode($userPermissions);
			die;
		}else{
			echo "No Records Found";
			die;
		}
	}

	public function actionCreateUserPermission(){
		$principleId = $_POST["user"];
		$type = "user";

		if(!isset($_POST["actions"])){
			$this->redirect('create');
		}

		YumPermission::model()->deleteAll("principal_id=".$principleId." and type='".$type."'");

		foreach($_POST["actions"] as $action){
			$comment = $action;
            
			$actionModel = YumAction::model()->findByAttributes(array("title"=> $action));

			if($actionModel == null){
				$actionModel = new YumAction;
				$actionModel->title = $action;
				$actionModel->subject = $action;
				$actionModel->comment = $action;
				$actionModel->save();
			}


			//YumPermission::model()->deleteAll("principal_id=".$principleId." and action='".$actionModel."' and type='".$type."'");
			$user_permission = YumPermission::model()->findByAttributes(array("principal_id"=>$principleId,"action"=> $action, "type"=>$type));

			if($user_permission == null){
				//try {
					$model = new YumPermission;
					$model->principal_id = $principleId;
					$model->action = $actionModel->id;
					$model->type = $type;
					$model->comment = $comment;
					$model->template = 0;
					$model->save();
				//} catch (Exception $e) {
					//echo 'Caught exception: ',  $e->getMessage(), "\n";
				//}

              
			  //echo "Created";
			}else{
				//echo "Exists";
			}
		}
		//die;

		$this->redirect('create');
	}

}
