<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'fields-form',
    'enableAjaxValidation' => false,
        ));
?>

<p class="help-block">Fields with <span class="required">*</span> are required.</p>
<div class="portlet box blue">
    <?php echo $form->errorSummary($model); ?>
    <div class="portlet-title">
        <div class="caption">
            <i class="icon-reorder"></i>
        </div>
        <div class="tools">
            <a href="#" class="collapse"></a>
            <a href="#portlet-config" data-toggle="modal" class="config"></a>
            <a href="#" class="reload"></a>
            <a href="#" class="remove"></a>
        </div>
    </div>
    <div class="portlet-body form">
        <form role="form">
            <div class="form-body">
                <div class="form-group">
                    <?php echo CHtml::activeLabelEx($model, 'varname'); ?>
                    <?php echo CHtml::activeTextField($model, 'varname',array('class'=>'form-control'), array('size' => 60, 'maxlength' => 50, $model->id !== null ? 'readonly' : '')); ?>
                    <?php echo CHtml::error($model, 'varname'); ?>
                    <p class="hint"><?php echo Yum::t('Allowed are lowercase letters and digits.'); ?></p>
                </div>

                <div class="form-group">
                    <?php echo CHtml::activeLabelEx($model, 'title'); ?>
                    <?php echo CHtml::activeTextField($model, 'title',array('class'=>'form-control'), array('size' => 60, 'maxlength' => 255)); ?>
                    <?php echo CHtml::error($model, 'title'); ?>
                    <p class="hint"><?php echo Yum::t('Field name on the language of "sourceLanguage".'); ?></p>
                </div>

                <div class="form-group">
                    <?php echo CHtml::activeLabelEx($model, 'hint'); ?>
                    <?php echo CHtml::activeTextField($model, 'hint',array('class'=>'form-control'), array('size' => 60)); ?>
                    <?php echo CHtml::error($model, 'hint'); ?>
                    <p class="hint"><?php echo Yum::t('Hint displayed to user e.g "You can enter more values and separate them using comma".'); ?></p>
                </div>	

                <div class="form-group">
                    <?php echo CHtml::activeLabelEx($model, 'field_type'); ?>
                    <?php
                    echo (($model->id) ? CHtml::activeTextField($model, 'field_type',array('class'=>'form-control'), array(
                                'size' => 60,
                                'maxlength' => 50,
                                'readonly' => true)) : CHtml::activeDropDownList($model, 'field_type', YumProfileField::itemAlias('field_type'),array('class'=>'form-control')));
                    ?>
                    <?php echo CHtml::error($model, 'field_type'); ?>
                    <p class="hint"><?php echo Yum::t('Column field type in the database'); ?></p>
                </div>

                <div class="form-group">
<?php echo CHtml::activeLabelEx($model, 'field_size'); ?>
                    <?php echo CHtml::activeTextField($model, 'field_size',array('class'=>'form-control'), array($model->id !== null ? 'readonly' : '')); ?>
                    <?php echo CHtml::error($model, 'field_size'); ?>
                    <p class="hint"><?php echo Yum::t('Field size in the database.'); ?></p>
                </div>

                <div class="form-group">
<?php echo CHtml::activeLabelEx($model, 'field_size_min'); ?>
                    <?php echo CHtml::activeTextField($model, 'field_size_min',array('class'=>'form-control')); ?>
                    <?php echo CHtml::error($model, 'field_size_min'); ?>
                    <p class="hint"><?php echo Yum::t('The minimum value of the field (form validator).'); ?></p>
                </div>

                <div class="form-group">
<?php echo CHtml::activeLabelEx($model, 'required'); ?>
                    <?php echo CHtml::activeDropDownList($model, 'required', YumProfileField::itemAlias('required'),array('class'=>'form-control')); ?>
                    <?php echo CHtml::error($model, 'required'); ?>
                    <p class="hint"><?php echo Yum::t('Required field (form validator).'); ?></p>
                </div>

                <div class="form-group">
<?php echo CHtml::activeLabelEx($model, 'match'); ?>
                    <?php echo CHtml::activeTextField($model, 'match',array('class'=>'form-control'), array('size' => 60, 'maxlength' => 255)); ?>
                    <?php echo CHtml::error($model, 'match'); ?>
                    <p class="hint"><?php echo Yum::t("Regular expression (example: '/^[A-Za-z0-9\s,]+$/u')."); ?></p>
                </div>

                <div class="form-group">
<?php echo CHtml::activeLabelEx($model, 'range'); ?>
                    <?php echo CHtml::activeTextField($model, 'range',array('class'=>'form-control'), array('size' => 60, 'maxlength' => 255)); ?>
                    <?php echo CHtml::error($model, 'range'); ?>
                    <p class="hint"><?php echo Yum::t('Predefined values (example: 1, 2, 3, 4, 5;).'); ?></p>
                </div>

                <div class="form-group">
<?php echo CHtml::activeLabelEx($model, 'error_message'); ?>
                    <?php echo CHtml::activeTextField($model, 'error_message',array('class'=>'form-control'), array('size' => 60, 'maxlength' => 255)); ?>
                    <?php echo CHtml::error($model, 'error_message'); ?>
                    <p class="hint"><?php echo Yum::t('Error message when validation fails.'); ?></p>
                </div>

                <div class="form-group">
<?php echo CHtml::activeLabelEx($model, 'other_validator'); ?>
                    <?php echo CHtml::activeTextField($model, 'other_validator',array('class'=>'form-control'), array('size' => 60, 'maxlength' => 255)); ?>
                    <?php echo CHtml::error($model, 'other_validator'); ?>
                </div>

                <div class="form-group">
<?php echo CHtml::activeLabelEx($model, 'default'); ?>
                    <?php echo CHtml::activeTextField($model, 'default',array('class'=>'form-control'), array('size' => 60, 'maxlength' => 255, $model->id !== null ? 'readonly' : '')); ?>
                    <?php echo CHtml::error($model, 'default'); ?>
                    <p class="hint"><?php echo Yum::t('The value of the default field (database).'); ?></p>
                </div>

                <div class="form-group">
<?php echo CHtml::activeLabelEx($model, 'position'); ?>
                    <?php echo CHtml::activeTextField($model, 'position',array('class'=>'form-control')); ?>
                    <?php echo CHtml::error($model, 'position'); ?>
                    <p class="hint"><?php echo Yii::t("UserModule.user", 'Display order of fields.'); ?></p>
                </div>

                <div class="form-group">
<?php echo CHtml::activeLabelEx($model, 'visible'); ?>
                    <?php echo CHtml::activeDropDownList($model, 'visible', YumProfileField::itemAlias('visible'),array('class'=>'form-control')); ?>
                    <?php echo CHtml::error($model, 'visible'); ?>
                </div>

                <div class="form-group">
<?php
$this->widget('bootstrap.widgets.TbButton', array(
    'buttonType' => 'submit',
    'type' => 'primary',
    'label' => $model->isNewRecord ? 'Create' : 'Save',
));
?>
                </div>

<?php $this->endWidget(); ?>

        </form>
    </div>
</div>