<?php

/**
 * This is the model class for table "weekendrate".
 *
 * The followings are the available columns in table 'weekendrate':
 * @property integer $id
 * @property string $Day
 * @property string $WorkingRate
 * @property string $NOTRate
 * @property string $DOTRate
 * @property string $NOTRang
 * @property string $DOTRang
 */
class Weekendrate extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'weekendrate';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('Day, WorkingRate, NOTRate, NOTRang, DOTRang', 'required'),
			array('Day', 'length', 'max'=>100),
			array('WorkingRate, NOTRate, DOTRate, NOTRang, DOTRang', 'length', 'max'=>9),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, Day, WorkingRate, NOTRate, DOTRate, NOTRang, DOTRang', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'Day' => 'Day',
			'WorkingRate' => 'Working Rate',
			'NOTRate' => 'Notrate',
			'DOTRate' => 'Dotrate',
			'NOTRang' => 'Notrang',
			'DOTRang' => 'Dotrang',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('Day',$this->Day,true);
		$criteria->compare('WorkingRate',$this->WorkingRate,true);
		$criteria->compare('NOTRate',$this->NOTRate,true);
		$criteria->compare('DOTRate',$this->DOTRate,true);
		$criteria->compare('NOTRang',$this->NOTRang,true);
		$criteria->compare('DOTRang',$this->DOTRang,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Weekendrate the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
