<?php

/**
 * This is the model class for table "volume".
 *
 * The followings are the available columns in table 'volume':
 * @property integer $id
 * @property string $retailer_code
 * @property string $retailer_name
 * @property string $retailer_type_code
 * @property string $territory_code
 * @property string $invoice_date
 * @property string $sales_volume
 */
class Volume extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Volume the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'volume';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('retailer_code, retailer_name, invoice_date, sales_volume', 'required'),
			array('retailer_code, retailer_name, retailer_type_code, territory_code, invoice_date, sales_volume', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, retailer_code, retailer_name, retailer_type_code, territory_code, invoice_date, sales_volume', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'retailer_code' => 'Retailer Code',
			'retailer_name' => 'Retailer Name',
			'retailer_type_code' => 'Retailer Type Code',
			'territory_code' => 'Territory Code',
			'invoice_date' => 'Invoice Date',
			'sales_volume' => 'Sales Volume',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('retailer_code',$this->retailer_code,true);
		$criteria->compare('retailer_name',$this->retailer_name,true);
		$criteria->compare('retailer_type_code',$this->retailer_type_code,true);
		$criteria->compare('territory_code',$this->territory_code,true);
		$criteria->compare('invoice_date',$this->invoice_date,true);
		$criteria->compare('sales_volume',$this->sales_volume,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}