<?php

/**
 * This is the model class for table "vehicle_unloading".
 *
 * The followings are the available columns in table 'vehicle_unloading':
 * @property integer $id
 * @property string $vehicleNumber
 * @property string $unloadingStart
 * @property string $unloadingEnd
 * @property integer $locationId
 * @property integer $status
 */
class VehicleUnloading extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VehicleUnloading the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vehicle_unloading';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vehicleNumber, unloadingStart, locationId, status', 'required'),
			array('locationId, status', 'numerical', 'integerOnly'=>true),
			array('vehicleNumber', 'length', 'max'=>50),
			array('unloadingEnd', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, vehicleNumber, unloadingStart, unloadingEnd, locationId, status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'vehicleNumber' => 'Vehicle Number',
			'unloadingStart' => 'Unloading Start',
			'unloadingEnd' => 'Unloading End',
			'locationId' => 'Location',
			'status' => 'Status',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('vehicleNumber',$this->vehicleNumber,true);
		$criteria->compare('unloadingStart',$this->unloadingStart,true);
		$criteria->compare('unloadingEnd',$this->unloadingEnd,true);
		$criteria->compare('locationId',$this->locationId);
		$criteria->compare('status',$this->status);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}