<?php

/**
 * This is the model class for table "vehicle_history".
 *
 * The followings are the available columns in table 'vehicle_history':
 * @property integer $id
 * @property integer $geoLocationId
 * @property string $name
 * @property string $vehicleId
 * @property string $arrivalTime
 * @property string $departureTime
 * @property string $waiting_time
 * @property string $volume
 * @property string $ratio
 * @property integer $minutes
 */
class VehicleHistory extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VehicleHistory the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vehicle_history';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('minutes', 'required'),
			array('geoLocationId, minutes', 'numerical', 'integerOnly'=>true),
			array('name', 'length', 'max'=>128),
			array('vehicleId', 'length', 'max'=>12),
			array('volume', 'length', 'max'=>10),
			array('arrivalTime, departureTime, waiting_time', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, geoLocationId, name, vehicleId, arrivalTime, departureTime, waiting_time, volume, ratio, minutes', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'geoLocationId' => 'Geo Location',
			'name' => 'Name',
			'vehicleId' => 'Vehicle',
			'arrivalTime' => 'Arrival Time',
			'departureTime' => 'Departure Time',
			'waiting_time' => 'Waiting Time',
			'volume' => 'Volume',
			'ratio' => 'Ratio',
			'minutes' => 'Minutes',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('geoLocationId',$this->geoLocationId);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('vehicleId',$this->vehicleId,true);
		$criteria->compare('arrivalTime',$this->arrivalTime,true);
		$criteria->compare('departureTime',$this->departureTime,true);
		$criteria->compare('waiting_time',$this->waiting_time,true);
		$criteria->compare('volume',$this->volume,true);
		$criteria->compare('ratio',$this->ratio,true);
		$criteria->compare('minutes',$this->minutes);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}
