<?php

/**
 * This is the model class for table "vehicle_details".
 *
 * The followings are the available columns in table 'vehicle_details':
 * @property integer $id
 * @property string $vehicleNo
 * @property string $vehicleType
 * @property string $capacity
 */
class VehicleDetails extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VehicleDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vehicle_details';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vehicleNo, vehicleType, capacity', 'required'),
			array('vehicleNo', 'length', 'max'=>10),
			array('vehicleType, capacity', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, vehicleNo, vehicleType, capacity', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'vehicleNo' => 'Vehicle No',
			'vehicleType' => 'Vehicle Type',
			'capacity' => 'Capacity',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('vehicleNo',$this->vehicleNo,true);
		$criteria->compare('vehicleType',$this->vehicleType,true);
		$criteria->compare('capacity',$this->capacity,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}