<?php

/**
 * This is the model class for table "user".
 *
 * The followings are the available columns in table 'user':
 * @property string $id
 * @property string $username
 * @property string $password
 * @property string $salt
 * @property string $activationKey
 * @property integer $createtime
 * @property integer $lastvisit
 * @property integer $lastaction
 * @property integer $lastpasswordchange
 * @property integer $superuser
 * @property integer $status
 * @property string $avatar
 * @property string $notifyType
 * @property integer $foodAllowance
 * @property string $employeeNo
 * @property string $epf
 * @property string $nic
 * @property string $department
 * @property integer $comeByVehicle
 * @property integer $businessUnitId
 * @property integer $phone_extension
 * @property integer $SiteId
 */
class User extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'user';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('username, password, salt, activationKey, epf, nic, comeByVehicle, businessUnitId, SiteId', 'required'),
			array('createtime, lastvisit, lastaction, lastpasswordchange, superuser, status, foodAllowance, comeByVehicle, businessUnitId, phone_extension, SiteId', 'numerical', 'integerOnly'=>true),
			array('username', 'length', 'max'=>20),
			array('password, salt, activationKey, employeeNo, epf, department', 'length', 'max'=>128),
			array('avatar', 'length', 'max'=>255),
			array('notifyType', 'length', 'max'=>9),
			array('nic', 'length', 'max'=>64),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, username, password, salt, activationKey, createtime, lastvisit, lastaction, lastpasswordchange, superuser, status, avatar, notifyType, foodAllowance, employeeNo, epf, nic, department, comeByVehicle, businessUnitId, phone_extension, SiteId', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'username' => 'Username',
			'password' => 'Password',
			'salt' => 'Salt',
			'activationKey' => 'Activation Key',
			'createtime' => 'Createtime',
			'lastvisit' => 'Lastvisit',
			'lastaction' => 'Lastaction',
			'lastpasswordchange' => 'Lastpasswordchange',
			'superuser' => 'Superuser',
			'status' => 'Status',
			'avatar' => 'Avatar',
			'notifyType' => 'Notify Type',
			'foodAllowance' => 'Food Allowance',
			'employeeNo' => 'Employee No',
			'epf' => 'Epf',
			'nic' => 'Nic',
			'department' => 'Department',
			'comeByVehicle' => 'Come By Vehicle',
			'businessUnitId' => 'Business Unit',
			'phone_extension' => 'Phone Extension',
			'SiteId' => 'Site',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('username',$this->username,true);
		$criteria->compare('password',$this->password,true);
		$criteria->compare('salt',$this->salt,true);
		$criteria->compare('activationKey',$this->activationKey,true);
		$criteria->compare('createtime',$this->createtime);
		$criteria->compare('lastvisit',$this->lastvisit);
		$criteria->compare('lastaction',$this->lastaction);
		$criteria->compare('lastpasswordchange',$this->lastpasswordchange);
		$criteria->compare('superuser',$this->superuser);
		$criteria->compare('status',$this->status);
		$criteria->compare('avatar',$this->avatar,true);
		$criteria->compare('notifyType',$this->notifyType,true);
		$criteria->compare('foodAllowance',$this->foodAllowance);
		$criteria->compare('employeeNo',$this->employeeNo,true);
		$criteria->compare('epf',$this->epf,true);
		$criteria->compare('nic',$this->nic,true);
		$criteria->compare('department',$this->department,true);
		$criteria->compare('comeByVehicle',$this->comeByVehicle);
		$criteria->compare('businessUnitId',$this->businessUnitId);
		$criteria->compare('phone_extension',$this->phone_extension);
		$criteria->compare('SiteId',$this->SiteId);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return User the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public static function getList() {
        return array('' => '') + CHtml::listData(self::model()->findAll(), 'id', 'username');
    }
}
