<?php

/**
 * This is the model class for table "timsheetchange".
 *
 * The followings are the available columns in table 'timsheetchange':
 * @property integer $id
 * @property integer $CreatedBy
 * @property string $CreatedON
 * @property string $OldInTime
 * @property string $NewIntime
 * @property string $OldOutTime
 * @property string $NewOutTime
 * @property integer $TimeSheetId
 *
 * The followings are the available model relations:
 * @property Timesheet $timeSheet
 */
class Timsheetchange extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'timsheetchange';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('CreatedBy, CreatedON, TimeSheetId', 'required'),
			array('CreatedBy, TimeSheetId', 'numerical', 'integerOnly'=>true),
			array('OldInTime, NewIntime, OldOutTime, NewOutTime', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, CreatedBy, CreatedON, OldInTime, NewIntime, OldOutTime, NewOutTime, TimeSheetId', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'timeSheet' => array(self::BELONGS_TO, 'Timesheet', 'TimeSheetId'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'CreatedBy' => 'Created By',
			'CreatedON' => 'Created On',
			'OldInTime' => 'Old In Time',
			'NewIntime' => 'New Intime',
			'OldOutTime' => 'Old Out Time',
			'NewOutTime' => 'New Out Time',
			'TimeSheetId' => 'Time Sheet',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('CreatedBy',$this->CreatedBy);
		$criteria->compare('CreatedON',$this->CreatedON,true);
		$criteria->compare('OldInTime',$this->OldInTime,true);
		$criteria->compare('NewIntime',$this->NewIntime,true);
		$criteria->compare('OldOutTime',$this->OldOutTime,true);
		$criteria->compare('NewOutTime',$this->NewOutTime,true);
		$criteria->compare('TimeSheetId',$this->TimeSheetId);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Timsheetchange the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
