<?php

/**
 * This is the model class for table "sites".
 *
 * The followings are the available columns in table 'sites':
 * @property integer $id
 * @property string $name
 * @property string $location
 * @property integer $contactnumber
 * @property integer $clusterid
 *
 * The followings are the available model relations:
 * @property Accounts[] $accounts
 * @property Department[] $departments
 * @property Employee[] $employees
 * @property Cluster $cluster
 */
class Sites extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'sites';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('name, location, clusterid', 'required'),
			array('contactnumber, clusterid', 'numerical', 'integerOnly'=>true),
			array('name', 'length', 'max'=>100),
			array('location', 'length', 'max'=>200),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, name, location, contactnumber, clusterid', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'accounts' => array(self::HAS_MANY, 'Accounts', 'siteid'),
			'departments' => array(self::HAS_MANY, 'Department', 'siteid'),
			'employees' => array(self::HAS_MANY, 'Employee', 'siteid'),
			'cluster' => array(self::BELONGS_TO, 'Cluster', 'clusterid'),
		);
	}

    public static function getList() {
        return array('' => '') + CHtml::listData(self::model()->findAll(), 'id', 'name');
	}

	
	
	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'name' => 'Name',
			'location' => 'Location',
			'contactnumber' => 'Contact Number',
			'clusterid' => 'Cluster',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('location',$this->location,true);
		$criteria->compare('contactnumber',$this->contactnumber);
		$criteria->compare('clusterid',$this->clusterid);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Sites the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public static function getDistributorList() {
        return CHtml::listData(self::model()->findAll(array("select"=>"distributorId as id,name", "order"=>"distributorId DESC")),'id','name');
	}
	
	public static function getDistributorListForUser() {
		if(Yii::app()->user->isAdmin()){
			return CHtml::listData(self::model()
			->findAll(array(
				"select"=>"distributorId as id,name", 
				"order"=>"distributorId DESC"
			)),'id','name');
		}else
		{
			$siteID = Yii::app()->user->data()->SiteId;
			return CHtml::listData(self::model()
			->findAll(array(
				"select"=>"distributorId as id,name", 
				"condition"=>"id = $siteID",
				"order"=>"distributorId DESC"
			)),'id','name');
		}
      }

}
