<?php

/**
 * This is the model class for table "shift".
 *
 * The followings are the available columns in table 'shift':
 * @property integer $id
 * @property string $StartTime
 * @property string $EndTime
 * @property integer $schedulid
 * @property string $name
 * @property string $description
 * @property string $salaryRate
 * @property string $FirstOTRate
 * @property string $SecondOTRate
 * @property string $FirstOTTimeRang
 *
 * The followings are the available model relations:
 * @property EmployeeShift[] $employeeShifts
 * @property Schedule $schedul
 * @property TeamShift[] $teamShifts
 */
class Shift extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'shift';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('StartTime, EndTime, schedulid,', 'required'),
			array('schedulid', 'numerical', 'integerOnly'=>true),
			array('name', 'length', 'max'=>100),
			array('description', 'length', 'max'=>250),
			array('salaryRate, FirstOTRate, SecondOTRate, FirstOTTimeRang', 'length', 'max'=>9),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, StartTime, EndTime, schedulid, name, description, salaryRate, FirstOTRate, SecondOTRate, FirstOTTimeRang', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'employeeShifts' => array(self::HAS_MANY, 'EmployeeShift', 'ShiftId'),
			'schedul' => array(self::BELONGS_TO, 'Schedule', 'schedulid'),
			'teamShifts' => array(self::HAS_MANY, 'TeamShift', 'shiftid'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'StartTime' => 'Start Time',
			'EndTime' => 'End Time',
			'schedulid' => 'Schedulid',
			'name' => 'Name',
			'description' => 'Description',
			'salaryRate' => 'Salary Rate',
			'FirstOTRate' => 'First Otrate',
			'SecondOTRate' => 'Second Otrate',
			'FirstOTTimeRang' => 'First Ottime Rang',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('StartTime',$this->StartTime,true);
		$criteria->compare('EndTime',$this->EndTime,true);
		$criteria->compare('schedulid',$this->schedulid);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('salaryRate',$this->salaryRate,true);
		$criteria->compare('FirstOTRate',$this->FirstOTRate,true);
		$criteria->compare('SecondOTRate',$this->SecondOTRate,true);
		$criteria->compare('FirstOTTimeRang',$this->FirstOTTimeRang,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Shift the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public static function getShifts($schedule) {
		
			  return array('' => '-- Select Shift --') + CHtml::listData(self::model()->findAllBySql("select * from shift where schedulid = $schedule"), 'id','name');
	  
		  }
}
