<?php

/**
 * This is the model class for table "routedetails".
 *
 * The followings are the available columns in table 'routedetails':
 * @property integer $id
 * @property string $businessUnit
 * @property string $territoryCode
 * @property string $routeCode
 * @property string $description
 * @property string $routeDefaultExecutive
 * @property string $routeDefaultVehicle
 * @property string $retailerCode
 * @property string $retailerName
 */
class Routedetails extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Routedetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'routedetails';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('businessUnit, territoryCode, routeCode, description, routeDefaultExecutive, routeDefaultVehicle, retailerCode, retailerName', 'required'),
			array('businessUnit, territoryCode', 'length', 'max'=>20),
			array('routeCode, routeDefaultExecutive, routeDefaultVehicle, retailerCode, retailerName', 'length', 'max'=>50),
			array('description', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, businessUnit, territoryCode, routeCode, description, routeDefaultExecutive, routeDefaultVehicle, retailerCode, retailerName', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'businessUnit' => 'Business Unit',
			'territoryCode' => 'Territory Code',
			'routeCode' => 'Route Code',
			'description' => 'Description',
			'routeDefaultExecutive' => 'Route Default Executive',
			'routeDefaultVehicle' => 'Route Default Vehicle',
			'retailerCode' => 'Retailer Code',
			'retailerName' => 'Retailer Name',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('businessUnit',$this->businessUnit,true);
		$criteria->compare('territoryCode',$this->territoryCode,true);
		$criteria->compare('routeCode',$this->routeCode,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('routeDefaultExecutive',$this->routeDefaultExecutive,true);
		$criteria->compare('routeDefaultVehicle',$this->routeDefaultVehicle,true);
		$criteria->compare('retailerCode',$this->retailerCode,true);
		$criteria->compare('retailerName',$this->retailerName,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}