<?php

/**
 * This is the model class for table "route_plan".
 *
 * The followings are the available columns in table 'route_plan':
 * @property integer $id
 * @property string $vehicleNumber
 * @property string $locationId
 * @property string $routeDescription
 * @property string $date
 * @property integer $status
 */
class RoutePlan extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return RoutePlan the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'route_plan';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vehicleNumber, locationId, routeDescription, date', 'required'),
			array('status', 'numerical', 'integerOnly'=>true),
			array('vehicleNumber, locationId', 'length', 'max'=>50),
			array('routeDescription', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, vehicleNumber, locationId, routeDescription, date, status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'vehicleNumber' => 'Vehicle Number',
			'locationId' => 'Location',
			'routeDescription' => 'Route Description',
			'date' => 'Date',
			'status' => 'Status',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('vehicleNumber',$this->vehicleNumber,true);
		$criteria->compare('locationId',$this->locationId,true);
		$criteria->compare('routeDescription',$this->routeDescription,true);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('status',$this->status);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}