<?php

/**
 * This is the model class for table "leave".
 *
 * The followings are the available columns in table 'leave':
 * @property integer $id
 * @property integer $EmoloyeeId
 * @property string $StartDate
 * @property integer $No_of_Day
 * @property integer $LeaveType
 * @property string $PaidType
 * @property string $Reason
 * @property integer $CreatedBy
 * @property string $CreatedTime
 * @property string $Approvedtime
 * @property integer $ApprovedBy
 * @property integer $Status
 *
 * The followings are the available model relations:
 * @property Employee $emoloyee
 */
class Leave extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'leave';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('EmoloyeeId, StartDate, No_of_Day, LeaveType, PaidType, Reason, CreatedBy, CreatedTime, Status', 'required'),
			array('EmoloyeeId, No_of_Day, LeaveType, CreatedBy, ApprovedBy, Status', 'numerical', 'integerOnly'=>true),
			array('PaidType', 'length', 'max'=>100),
			array('Reason', 'length', 'max'=>250),
			array('Approvedtime', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, EmoloyeeId, StartDate, No_of_Day, LeaveType, PaidType, Reason, CreatedBy, CreatedTime, Approvedtime, ApprovedBy, Status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'emoloyee' => array(self::BELONGS_TO, 'Employee', 'EmoloyeeId'),
                        'levetype' => array(self::BELONGS_TO, 'Leavetype', 'LeaveType'),
                        'CreatedUser' => array(self::BELONGS_TO, 'User', 'CreatedBy'),
                        'ApprovedUser' => array(self::BELONGS_TO, 'User', 'ApprovedBy'),
		
		);
	}
           public static function itemAlias($type,$code = NULL) {
               $_items = array(
               'Status' => array(
               '0' => Yum::t('Pending'),
               '1' => Yum::t('Approved'),
               '2' => Yum::t('Rejected'),
            ),
        );
        if (isset($code)) {
            return isset($_items[$type][$code]) ? $_items[$type][$code] : false;
        } else {
            return isset($_items[$type]) ? $_items[$type] : false;
        }
    }
	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'EmoloyeeId' => 'Emoloyee',
			'StartDate' => 'Start Date',
			'No_of_Day' => 'No Of Day',
			'LeaveType' => 'Leave Type',
			'PaidType' => 'Paid Type',
			'Reason' => 'Reason',
			'CreatedBy' => 'Created By',
			'CreatedTime' => 'Created Time',
			'Approvedtime' => 'Approvedtime',
			'ApprovedBy' => 'Approved By',
			'Status' => 'Status',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('EmoloyeeId',$this->EmoloyeeId);
		$criteria->compare('StartDate',$this->StartDate,true);
		$criteria->compare('No_of_Day',$this->No_of_Day);
		$criteria->compare('LeaveType',$this->LeaveType);
		$criteria->compare('PaidType',$this->PaidType,true);
		$criteria->compare('Reason',$this->Reason,true);
		$criteria->compare('CreatedBy',$this->CreatedBy);
		$criteria->compare('CreatedTime',$this->CreatedTime,true);
		$criteria->compare('Approvedtime',$this->Approvedtime,true);
		$criteria->compare('ApprovedBy',$this->ApprovedBy);
		$criteria->compare('Status',$this->Status);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Leave the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
