<?php

/**
 * This is the model class for table "invalidassetdetection".
 *
 * The followings are the available columns in table 'invalidassetdetection':
 * @property integer $id
 * @property integer $assetId
 * @property string $serial
 * @property string $type
 * @property string $readerIp
 * @property string $detectedOn
 */
class Invalidassetdetection extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Invalidassetdetection the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'invalidassetdetection';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('assetId', 'numerical', 'integerOnly'=>true),
			array('serial', 'length', 'max'=>128),
			array('type, readerIp', 'length', 'max'=>48),
			array('detectedOn', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, assetId, serial, type, readerIp, detectedOn', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'assetId' => 'Asset',
			'serial' => 'Serial',
			'type' => 'Type',
			'readerIp' => 'Reader Ip',
			'detectedOn' => 'Detected On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('assetId',$this->assetId);
		$criteria->compare('serial',$this->serial,true);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('readerIp',$this->readerIp,true);
		$criteria->compare('detectedOn',$this->detectedOn,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}