<?php

/**
 * This is the model class for table "initial_plan".
 *
 * The followings are the available columns in table 'initial_plan':
 * @property integer $id
 * @property string $businessUnit
 * @property string $territoryCode
 * @property integer $visitNumber
 * @property string $visitDate
 * @property string $executiveCode
 * @property string $routeCode
 * @property string $routeDecription
 * @property string $vehicle
 * @property string $retailerCode
 * @property string $retailerName
 * @property integer $status
 */
class InitialPlan extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return InitialPlan the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'initial_plan';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('businessUnit, territoryCode, visitNumber, visitDate, executiveCode, routeCode, routeDecription, vehicle, retailerCode, retailerName', 'required'),
			array('visitNumber, status', 'numerical', 'integerOnly'=>true),
			array('businessUnit, territoryCode, executiveCode, routeCode, vehicle, retailerCode', 'length', 'max'=>20),
			array('routeDecription, retailerName', 'length', 'max'=>50),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, businessUnit, territoryCode, visitNumber, visitDate, executiveCode, routeCode, routeDecription, vehicle, retailerCode, retailerName, status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'businessUnit' => 'Business Unit',
			'territoryCode' => 'Territory Code',
			'visitNumber' => 'Visit Number',
			'visitDate' => 'Visit Date',
			'executiveCode' => 'Executive Code',
			'routeCode' => 'Route Code',
			'routeDecription' => 'Route Decription',
			'vehicle' => 'Vehicle',
			'retailerCode' => 'Retailer Code',
			'retailerName' => 'Retailer Name',
			'status' => 'Status',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('businessUnit',$this->businessUnit,true);
		$criteria->compare('territoryCode',$this->territoryCode,true);
		$criteria->compare('visitNumber',$this->visitNumber);
		$criteria->compare('visitDate',$this->visitDate,true);
		$criteria->compare('executiveCode',$this->executiveCode,true);
		$criteria->compare('routeCode',$this->routeCode,true);
		$criteria->compare('routeDecription',$this->routeDecription,true);
		$criteria->compare('vehicle',$this->vehicle,true);
		$criteria->compare('retailerCode',$this->retailerCode,true);
		$criteria->compare('retailerName',$this->retailerName,true);
		$criteria->compare('status',$this->status);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}