<?php

/**
 * This is the model class for table "holydays".
 *
 * The followings are the available columns in table 'holydays':
 * @property integer $id
 * @property string $Is_Public
 * @property string $Is_Bank
 * @property string $Is_Mercantile
 * @property string $Is_Poyaday
 * @property string $Date
 * @property string $WorkingRate
 * @property string $NOTRate
 * @property string $DOTRate
 * @property string $Description
 */
class Holydays extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'holydays';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('Date, WorkingRate, NOTRate, DOTRate, Description', 'required'),
			array('Is_Public, Is_Bank, Is_Mercantile, Is_Poyaday', 'length', 'max'=>50),
			array('WorkingRate, NOTRate, DOTRate', 'length', 'max'=>9),
			array('Description', 'length', 'max'=>250),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, Is_Public, Is_Bank, Is_Mercantile, Is_Poyaday, Date, WorkingRate, NOTRate, DOTRate, Description', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'Is_Public' => 'Is Public',
			'Is_Bank' => 'Is Bank',
			'Is_Mercantile' => 'Is Mercantile',
			'Is_Poyaday' => 'Is Poyaday',
			'Date' => 'Date',
			'WorkingRate' => 'Working Rate',
			'NOTRate' => 'N-OT Rate',
			'DOTRate' => 'D-OT Rate',
			'Description' => 'Description',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('Is_Public',$this->Is_Public,true);
		$criteria->compare('Is_Bank',$this->Is_Bank,true);
		$criteria->compare('Is_Mercantile',$this->Is_Mercantile,true);
		$criteria->compare('Is_Poyaday',$this->Is_Poyaday,true);
		$criteria->compare('Date',$this->Date,true);
		$criteria->compare('WorkingRate',$this->WorkingRate,true);
		$criteria->compare('NOTRate',$this->NOTRate,true);
		$criteria->compare('DOTRate',$this->DOTRate,true);
		$criteria->compare('Description',$this->Description,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Holydays the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
