<?php

/**
 * This is the model class for table "geo_location_history".
 *
 * The followings are the available columns in table 'geo_location_history':
 * @property integer $id
 * @property integer $geoLocationId
 * @property string $vehicleId
 * @property string $timestamp
 * @property integer $alarmType
 * @property string $company_name
 */
class GeoLocationHistory extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return GeoLocationHistory the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'geo_location_history';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('geoLocationId, vehicleId, timestamp, alarmType, company_name', 'required'),
			array('geoLocationId, alarmType', 'numerical', 'integerOnly'=>true),
			array('vehicleId', 'length', 'max'=>50),
			array('company_name', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, geoLocationId, vehicleId, timestamp, alarmType, company_name', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'geoLocationId' => 'Geo Location',
			'vehicleId' => 'Vehicle',
			'timestamp' => 'Timestamp',
			'alarmType' => 'Alarm Type',
			'company_name' => 'Company Name',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('geoLocationId',$this->geoLocationId);
		$criteria->compare('vehicleId',$this->vehicleId,true);
		$criteria->compare('timestamp',$this->timestamp,true);
		$criteria->compare('alarmType',$this->alarmType);
		$criteria->compare('company_name',$this->company_name,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}