<?php

/**
 * This is the model class for table "gate_pass".
 *
 * The followings are the available columns in table 'gate_pass':
 * @property integer $id
 * @property string $gate
 * @property integer $authorized_person
 * @property string $schedule_date
 * @property integer $status
 * @property string $CreatedOn
 * @property integer $CreatedBy
 */
class GatePass extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return GatePass the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'gate_pass';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('gate, authorized_person, schedule_date, status, CreatedOn, CreatedBy', 'required'),
			array('authorized_person, status, CreatedBy', 'numerical', 'integerOnly'=>true),
			array('gate', 'length', 'max'=>50),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, gate, authorized_person, schedule_date, status, CreatedOn, CreatedBy', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'status0' => array(self::BELONGS_TO, 'GatepassStatus', 'status'),
			'user' => array(self::BELONGS_TO, 'User', 'authorized_person'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'gate' => 'Gate',
			'authorized_person' => 'Authorized Person',
			'schedule_date' => 'Schedule Date',
			'status' => 'Status',
			'CreatedOn' => 'Created On',
			'CreatedBy' => 'Created By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('gate',$this->gate,true);
		if(Yii::app()->user->isAdmin()){
			$criteria->compare('authorized_person',$this->authorized_person);
		}

		else{
			$userId =  Yii::app()->user->getId(); 		
			$criteria->compare('authorized_person',$userId);
		}
		$criteria->compare('authorized_person',$this->authorized_person);
		$criteria->compare('schedule_date',$this->schedule_date,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('CreatedOn',$this->CreatedOn,true);
		$criteria->compare('CreatedBy',$this->CreatedBy);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}