<?php

/**
 * This is the model class for table "employeesalary".
 *
 * The followings are the available columns in table 'employeesalary':
 * @property integer $id
 * @property integer $employeeid
 * @property double $monthsalary
 * @property double $DalySalary
 * @property double $HourlyRate
 * @property double $DoubleOTRate
 * @property double $OTRate
 * @property integer $CreatedBy
 * @property string $CreatedOn
 * @property integer $Status
 */
class Employeesalary extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'employeesalary';
	}

	
	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employeeid, monthsalary, DalySalary, HourlyRate, DoubleOTRate, OTRate', 'required'),
			array('employeeid, CreatedBy, Status', 'numerical', 'integerOnly'=>true),
			array('monthsalary, DalySalary, HourlyRate, DoubleOTRate, OTRate', 'numerical'),
			array('CreatedOn', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, employeeid, monthsalary, DalySalary, HourlyRate, DoubleOTRate, OTRate, CreatedBy, CreatedOn, Status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employeeid' => 'Employeeid',
			'monthsalary' => 'Monthsalary',
			'DalySalary' => 'Daly Salary',
			'HourlyRate' => 'Hourly Rate',
			'DoubleOTRate' => 'Double Otrate',
			'OTRate' => 'Otrate',
			'CreatedBy' => 'Created By',
			'CreatedOn' => 'Created On',
			'Status' => 'Status',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('employeeid',$this->employeeid);
		$criteria->compare('monthsalary',$this->monthsalary);
		$criteria->compare('DalySalary',$this->DalySalary);
		$criteria->compare('HourlyRate',$this->HourlyRate);
		$criteria->compare('DoubleOTRate',$this->DoubleOTRate);
		$criteria->compare('OTRate',$this->OTRate);
		$criteria->compare('CreatedBy',$this->CreatedBy);
		$criteria->compare('CreatedOn',$this->CreatedOn,true);
		$criteria->compare('Status',$this->Status);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Employeesalary the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
