<?php

/**
 * This is the model class for table "employee_tshirt".
 *
 * The followings are the available columns in table 'employee_tshirt':
 * @property integer $issueID
 * @property integer $empID
 * @property string $issuedDate
 * @property string $returnedDate
 * @property string $Status
 */
class EmployeeTshirt extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EmployeeTshirt the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'employee_tshirt';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('empID, issuedDate', 'required'),
			array('empID', 'numerical', 'integerOnly'=>true),
			array('Status', 'length', 'max'=>20),
			array('returnedDate', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('issueID, empID, issuedDate, returnedDate, Status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'issueID' => 'Issue',
			'empID' => 'Emp',
			'issuedDate' => 'Issued Date',
			'returnedDate' => 'Returned Date',
			'Status' => 'Status',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('issueID',$this->issueID);
		$criteria->compare('empID',$this->empID);
		$criteria->compare('issuedDate',$this->issuedDate,true);
		$criteria->compare('returnedDate',$this->returnedDate,true);
		$criteria->compare('Status',$this->Status,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}