<?php

/**
 * This is the model class for table "employee_status_history".
 *
 * The followings are the available columns in table 'employee_status_history':
 * @property integer $id
 * @property integer $emp_id
 * @property integer $status_id
 * @property string $affective_date
 * @property string $description
 * @property string $responsible_person
 */
class EmployeeStatusHistory extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EmployeeStatusHistory the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'employee_status_history';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('emp_id, status_id, responsible_person', 'required'),
			array('emp_id, status_id', 'numerical', 'integerOnly'=>true),
			array('description', 'length', 'max'=>500),
			array('responsible_person', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, emp_id, status_id, affective_date, description, responsible_person', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'emp_id' => 'Emp',
			'status_id' => 'Status',
			'affective_date' => 'Affective Date',
			'description' => 'Description',
			'responsible_person' => 'Responsible Person',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('emp_id',$this->emp_id);
		$criteria->compare('status_id',$this->status_id);
		$criteria->compare('affective_date',$this->affective_date,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('responsible_person',$this->responsible_person,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}