<?php

/**
 * This is the model class for table "employee_shift".
 *
 * The followings are the available columns in table 'employee_shift':
 * @property integer $id
 * @property integer $Status
 * @property integer $EmployeeId
 * @property integer $ShiftId
 * @property string $DateTime
 *
 * The followings are the available model relations:
 * @property Employee $employee
 * @property Shift $shift
 * @property Timesheet[] $timesheets
 */
class EmployeeShift extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'employee_shift';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('Status, EmployeeId, ShiftId, DateTime', 'required'),
			array('Status, EmployeeId,schedulid, ShiftId', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, Status, EmployeeId, ShiftId, DateTime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'employee' => array(self::BELONGS_TO, 'Employee', 'EmployeeId'),
			'shift' => array(self::BELONGS_TO, 'Shift', 'ShiftId'),
			'timesheets' => array(self::HAS_MANY, 'Timesheet', 'EmployeeShiftid'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'Status' => 'Status',
			'EmployeeId' => 'Employee',
			'ShiftId' => 'Shift',
			'DateTime' => 'Date Time',
                        'schedulid' => 'schedulid'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('Status',$this->Status);
		$criteria->compare('EmployeeId',$this->EmployeeId);
		$criteria->compare('ShiftId',$this->ShiftId);
		$criteria->compare('DateTime',$this->DateTime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EmployeeShift the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
