<?php

/**
 * This is the model class for table "employee_designation".
 *
 * The followings are the available columns in table 'employee_designation':
 * @property integer $id
 * @property integer $Status
 * @property integer $EmployeeId
 * @property integer $DesignationId
 * @property string $DateTime
 *
 * The followings are the available model relations:
 * @property Designation $designation
 * @property Employee $employee
 * @property Timesheet[] $timesheets
 */
class EmployeeDesignation extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'employee_designation';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('Status, EmployeeId, DesignationId', 'required'),
			array('Status, EmployeeId, DesignationId', 'numerical', 'integerOnly'=>true),
			array('DateTime', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, Status, EmployeeId, DesignationId, DateTime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'designation' => array(self::BELONGS_TO, 'Designation', 'DesignationId'),
			'employee' => array(self::BELONGS_TO, 'Employee', 'EmployeeId'),
			'timesheets' => array(self::HAS_MANY, 'Timesheet', 'EmployeeDesignaId'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'Status' => 'Status',
			'EmployeeId' => 'Employee',
			'DesignationId' => 'Designation',
			'DateTime' => 'Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('Status',$this->Status);
		$criteria->compare('EmployeeId',$this->EmployeeId);
		$criteria->compare('DesignationId',$this->DesignationId);
		$criteria->compare('DateTime',$this->DateTime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EmployeeDesignation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
