<?php

/**
 * This is the model class for table "employee_asset".
 *
 * The followings are the available columns in table 'employee_asset':
 * @property integer $id
 * @property integer $empID
 * @property string $issuedDate
 * @property string $returnedDate
 * @property integer $assetId
 * @property string $Status
 */
class EmployeeAsset extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EmployeeAsset the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'employee_asset';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('empID, issuedDate, assetId, Status', 'required'),
			array('empID, assetId', 'numerical', 'integerOnly'=>true),
			array('Status', 'length', 'max'=>48),
			array('returnedDate', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, empID, issuedDate, returnedDate, assetId, Status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'asset' => array(self::BELONGS_TO, 'Asset', 'assetId'),
			'employee' => array(self::BELONGS_TO, 'Employee', 'empID'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'empID' => 'Employee',
			'issuedDate' => 'Issued Date',
			'returnedDate' => 'Returned Date',
			'assetId' => 'Asset',
			'Status' => 'Status',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('empID',$this->empID);
		$criteria->compare('issuedDate',$this->issuedDate,true);
		$criteria->compare('returnedDate',$this->returnedDate,true);
		$criteria->compare('assetId',$this->assetId);
		$criteria->compare('Status',$this->Status,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}