<?php

/**
 * This is the model class for table "employee".
 *
 * The followings are the available columns in table 'employee':
 * @property integer $id
 * @property string $title
 * @property string $gender
 * @property string $CivilStatus
 * @property string $FirstName
 * @property string $LastName
 * @property string $SurName
 * @property string $Namewithini
 * @property string $FullName
 * @property string $nic
 * @property string $date_of_birth
 * @property string $address
 * @property integer $designationid
 * @property string $joindate
 * @property integer $paymentmethodid
 * @property integer $siteid
 * @property integer $departmentid
 * @property integer $categoryid
 * @property integer $supplierid
 * @property integer $tshirtsize
 * @property integer $shoesize
 * @property string $EPFNo
 * @property string $Appointment
 * @property string $Confirmationdate
 * @property string $resigndate
 * @property string $description
 * @property integer $LabourCategory
 * @property integer $statusId
 * @property string $profileImage

 * The followings are the available model relations:
 * @property Contact[] $contacts
 * @property Category $category
 * @property Supplier $supplier
 * @property Sites $site
 * @property Paymentmethod $paymentmethod
 * @property Department $department
 * @property Tshirt $tshirtsize0
 * @property Shoes $shoesize0
 * @property EmployeeAccount[] $employeeAccounts
 * @property EmployeeDesignation[] $employeeDesignations
 * @property EmployeeShift[] $employeeShifts
 * @property Leave[] $leaves
 * @property Payment[] $payments
 * @property Timelog[] $timelogs
 * @property Timesheet[] $timesheets
 */
class Employee extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Employee the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'employee';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('title, gender, CivilStatus,LabourCategory, FirstName, LastName, SurName, Namewithini, FullName, nic, designationid, joindate, paymentmethodid, siteid, departmentid,Accountid, categoryid', 'required'),
			array('designationid, paymentmethodid,LabourCategory, siteid, departmentid, categoryid, supplierid, tshirtsize,Accountid,TeamStatus, shoesize', 'numerical', 'integerOnly'=>true),
			array('nic', 'unique'),
			array('title, gender', 'length', 'max'=>20),
			array('CivilStatus, nic, EPFNo', 'length', 'max'=>50),
			array('FirstName, LastName', 'length', 'max'=>100),
			array('SurName, Namewithini, FullName, description, status_description,profileImage', 'length', 'max'=>250),
			array('address', 'length', 'max'=>200),
			array('date_of_birth, Appointment, Confirmationdate, resigndate', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, title, gender, CivilStatus, FirstName, LastName, SurName, Namewithini, FullName, nic, date_of_birth, address, designationid,TeamStatus, joindate,Accountid, paymentmethodid, siteid, departmentid, categoryid, supplierid, tshirtsize, shoesize, EPFNo, Appointment, Confirmationdate, resigndate, description, statusId,profileImage', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'contacts' => array(self::HAS_MANY, 'Contact', 'employeeid'),
			'category' => array(self::BELONGS_TO, 'Category', 'categoryid'),
			'supplier' => array(self::BELONGS_TO, 'Supplier', 'supplierid'),
			'status0' => array(self::BELONGS_TO, 'EmployeeStatus', 'statusId'),
			'site' => array(self::BELONGS_TO, 'Sites', 'siteid'),
			'paymentmethod' => array(self::BELONGS_TO, 'Paymentmethod', 'paymentmethodid'),
			'department' => array(self::BELONGS_TO, 'Department', 'departmentid'),
			'tshirtsize0' => array(self::BELONGS_TO, 'Tshirt', 'tshirtsize'),
			'shoesize0' => array(self::BELONGS_TO, 'Shoes', 'shoesize'),
			'employeeAccounts' => array(self::HAS_MANY, 'EmployeeAccount', 'employeeid'),
			'employeeDesignations' => array(self::HAS_MANY, 'EmployeeDesignation', 'EmployeeId'),
			'employeeShifts' => array(self::HAS_MANY, 'EmployeeShift', 'EmployeeId'),
			'leaves' => array(self::HAS_MANY, 'Leave', 'EmoloyeeId'),
			'payments' => array(self::HAS_MANY, 'Payment', 'employeeid'),
			'timelogs' => array(self::HAS_MANY, 'Timelog', 'Employeeid'),
			'timesheets' => array(self::HAS_MANY, 'Timesheet', 'EmployeeId'),
		);
	}
	public static function getList() {
			return array('' => '') + CHtml::listData(self::model()->findAll(), 'id', 'Namewithini');
	}

	public static function getResults(){
		return array(''=>'-- select employee--')+CHtml::listData(self::model()->findAll(),'id','nic');
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'title' => 'Title',
			'gender' => 'Gender',
			'CivilStatus' => 'Civil Status',
			'FirstName' => 'First Name',
			'LastName' => 'Last Name',
			'SurName' => 'Sur Name',
			'Namewithini' => 'Namewithini',
			'FullName' => 'Full Name',
			'nic' => 'Nic',
			'date_of_birth' => 'Date Of Birth',
			'address' => 'Address',
			'designationid' => 'Designationid',
			'joindate' => 'Joindate',
			'paymentmethodid' => 'Paymentmethodid',
			'siteid' => 'Siteid',
			'departmentid' => 'Departmentid',
			'categoryid' => 'Categoryid',
			'supplierid' => 'Supplierid',
			'tshirtsize' => 'Tshirtsize',
			'shoesize' => 'Shoesize',
			'EPFNo' => 'Epfno',
			'Appointment' => 'Appointment',
			'Confirmationdate' => 'Confirmationdate',
			'resigndate' => 'Resigndate',
			'description' => 'Description',
                        'LabourCategory' => 'Labour Category',
                        'Accountid' => 'Account',
						'TeamStatus'=>'TeamStatus',
						'statusId' => 'Status',
						'profileImage'=> 'Profile Image',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('gender',$this->gender,true);
		$criteria->compare('CivilStatus',$this->CivilStatus,true);
		$criteria->compare('FirstName',$this->FirstName,true);
		$criteria->compare('LastName',$this->LastName,true);
		$criteria->compare('SurName',$this->SurName,true);
		$criteria->compare('Namewithini',$this->Namewithini,true);
		$criteria->compare('FullName',$this->FullName,true);
		$criteria->compare('nic',$this->nic,true);
		$criteria->compare('date_of_birth',$this->date_of_birth,true);
		$criteria->compare('address',$this->address,true);
		$criteria->compare('designationid',$this->designationid);
		$criteria->compare('joindate',$this->joindate,true);
		$criteria->compare('paymentmethodid',$this->paymentmethodid);
		$criteria->compare('siteid',$this->siteid);
		$criteria->compare('departmentid',$this->departmentid);
		$criteria->compare('categoryid',$this->categoryid);
		$criteria->compare('supplierid',$this->supplierid);
		$criteria->compare('tshirtsize',$this->tshirtsize);
		$criteria->compare('shoesize',$this->shoesize);
		$criteria->compare('EPFNo',$this->EPFNo,true);
		$criteria->compare('Appointment',$this->Appointment,true);
		$criteria->compare('Confirmationdate',$this->Confirmationdate,true);
		$criteria->compare('resigndate',$this->resigndate,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('LabourCategory',$this->LabourCategory);
		$criteria->compare('statusId',$this->statusId);
		$criteria->compare('profileImage',$this->profileImage,true);
		
                $criteria->compare('Accountid',$this->Accountid,true);
                $criteria->compare('TeamStatus',$this->TeamStatus,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}