<?php

/**
 * This is the model class for table "eligible_leaves".
 *
 * The followings are the available columns in table 'eligible_leaves':
 * @property integer $id
 * @property integer $designationId
 * @property integer $leaveTypeId
 * @property integer $eligibleLeaves
 * @property integer $createdBy
 * @property string $createdOn
 *
 * The followings are the available model relations:
 * @property Designation $designation
 * @property Leavetype $leaveType
 */
class EligibleLeaves extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EligibleLeaves the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'eligible_leaves';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('designationId, leaveTypeId, eligibleLeaves, createdBy, createdOn', 'required'),
			array('designationId, leaveTypeId, eligibleLeaves, createdBy', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, designationId, leaveTypeId, eligibleLeaves, createdBy, createdOn', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'designation' => array(self::BELONGS_TO, 'Designation', 'designationId'),
			'leaveType' => array(self::BELONGS_TO, 'Leavetype', 'leaveTypeId'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'designationId' => 'Designation',
			'leaveTypeId' => 'Leave Type',
			'eligibleLeaves' => 'Eligible Leaves',
			'createdBy' => 'Created By',
			'createdOn' => 'Created On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('designationId',$this->designationId);
		$criteria->compare('leaveTypeId',$this->leaveTypeId);
		$criteria->compare('eligibleLeaves',$this->eligibleLeaves);
		$criteria->compare('createdBy',$this->createdBy);
		$criteria->compare('createdOn',$this->createdOn,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}