<?php

/**
 * This is the model class for table "designation_salary".
 *
 * The followings are the available columns in table 'designation_salary':
 * @property integer $id
 * @property string $MonthlySalary
 * @property integer $CreatedBy
 * @property string $CreatedOn
 * @property integer $Status
 * @property integer $DesignationId
 * @property integer $Siteid
 *
 * The followings are the available model relations:
 * @property Designation $designation
 * @property Timesheet[] $timesheets
 */
class DesignationSalary extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'designation_salary';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('MonthlySalary, DailySalary, CreatedBy, CreatedOn, Status, DesignationId, Siteid', 'required'),
			array('CreatedBy, Status, DesignationId, Siteid', 'numerical', 'integerOnly'=>true),
			array('MonthlySalary, DailySalary', 'length', 'max'=>10),
			array('MonthlySalary, DailySalary', 'default', 'value'=>0),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, MonthlySalary, DailySalary, CreatedBy, CreatedOn, Status, DesignationId, Siteid', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'designation' => array(self::BELONGS_TO, 'Designation', 'DesignationId'),
			'timesheets' => array(self::HAS_MANY, 'Timesheet', 'Designationsalaryid'),
			'User' => array(self::BELONGS_TO, 'YumUser', 'CreatedBy'),
            'Sites' => array(self::BELONGS_TO, 'Sites', 'Siteid'),
        );
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'MonthlySalary' => 'Monthly Salary',
			'DailySalary'=> 'Daily Salary',
			'CreatedBy' => 'Created By',
			'CreatedOn' => 'Created On',
			'Status' => 'Status',
			'DesignationId' => 'Designation',
			'Siteid' => 'Site',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('MonthlySalary',$this->MonthlySalary,true);
		$criteria->compare('DailySalary',$this->DailySalary,true);
		$criteria->compare('CreatedBy',$this->CreatedBy);
		$criteria->compare('CreatedOn',$this->CreatedOn,true);
		$criteria->compare('Status',$this->Status);
		$criteria->compare('DesignationId',$this->DesignationId);
		
		$sitid = Yii::app()->user->data()->SiteId;
		$criteria->compare('Siteid',$sitid);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return DesignationSalary the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public static function itemAlias($type,$code = NULL) {
        $_items = array(
            'Status' => array(
                '0' => Yum::t('Inactive'),
                '1' => Yum::t('Active'),
            ),
        );
        if (isset($code)) {
            return isset($_items[$type][$code]) ? $_items[$type][$code] : false;
        } else {
            return isset($_items[$type]) ? $_items[$type] : false;
        }
    }
}
