<?php

class ZoneApiController extends Controller {
    /**
     * Default response format
     * either 'json' or 'xml'
     */
    private $format = 'json';
    
    /**
     * @return array action filters
     */
    public function filters() {
        return array();
    }

    public function actionRegisterZone() {
        
        $body = @file_get_contents('php://input');
        $obj = json_decode($body);

        $zoneName = $obj->name;
        $zoneUid = $obj->uid;

        $zone = new Zone;
        $zone->name = $zoneName;
        $zone->uid = $zoneUid;
        $zone->save();

        $this->_sendResponse(200, CJSON::encode($zone));
    }

    public function actionSearchZone() {
        
        $body = @file_get_contents('php://input');
        $obj = json_decode($body);

        $zoneUid = $obj->uid;

        $zone = Zone::model()->findByAttributes(array("uid"=>$zoneUid));

        $this->_sendResponse(200, CJSON::encode($zone));
    }

    public function actionAssignAssetToZone() {
        
        $body = @file_get_contents('php://input');
        $obj = json_decode($body);

        $zoneId = $obj->ZoneId;
        $assets = $obj->Assets;

        $zone = Zone::model()->findByAttributes(array("uid"=> $zoneId ));
        

        $response = array();

        foreach ($assets as $asset) {
            $assetModel = Asset::model()->findByAttributes(array("uid"=> $asset ));
            $zoneAsset = new ZoneAsset;
            $zoneAsset->zone_id = $zone->id;
            $zoneAsset->asset_id = $assetModel->id;
            $zoneAsset->asigned_on = date('Y-m-d H:i:s');
            $zoneAsset->status = 1;
            //echo CHtml::errorSummary($zoneAsset->getErrors());
            //die;
            $zoneAsset->save();
            $response[] = $zoneAsset;
        }

        $this->_sendResponse(200, CJSON::encode($response));
    }

    public function actionSearchAsset() {
        
        $body = @file_get_contents('php://input');
        $obj = json_decode($body);

        $assetUid = $obj->uid;

        $asset = Asset::model()->findByAttributes(array("uid"=>$assetUid));

        $this->_sendResponse(200, CJSON::encode($asset));
    }

    public function actionSearchAssetsByZone() {
        
        $body = @file_get_contents('php://input');
        $obj = json_decode($body);

        $zoneUid = $obj->uid;
        $response = array();
        $zone = Zone::model()->findByAttributes(array("uid"=> $zoneUid ));
        $zoneAssets = ZoneAsset::model()->findAllByAttributes(array("zone_id"=>$zone->id));
        
        
        foreach ($zoneAssets as $za) {
            $asset = Asset::model()->findByPk($za->asset_id);
            $response[] = $asset;
        }

        $this->_sendResponse(200, CJSON::encode($response));
    }
    
}

?>