<?php

class VehicleApiController extends Controller {
    /**
     * Default response format
     * either 'json' or 'xml'
     */
    private $format = 'json';
    
    /**
     * @return array action filters
     */
    public function filters() {
        return array();
    }

    public function actionLoadingStart() {
        try {
            $body = @file_get_contents('php://input');
            $obj = json_decode($body);

            $vehicleNumber = $obj->vehicleNumber;
            $locationId = $obj->locationId;
            $loadingStart = $obj->loadingStart;

            $vehicleLoading = new VehicleLoading;
            $vehicleLoading->vehicleNumber = $vehicleNumber;
            $vehicleLoading->locationId = $locationId;
            $vehicleLoading->loadingStart = $loadingStart;
            $vehicleLoading->status = 1;

            if($vehicleLoading->save()){
                $this->_sendResponse(200, CJSON::encode(array("Success"=> true,"referenceId"=> $vehicleLoading->id)));
            }else{
                $this->_sendResponse(200, CJSON::encode(array("Success"=> false)));
            }
        }catch(Exception $e){
            $this->_sendResponse(200, CJSON::encode(array("Success"=> false,"Error"=> $e)));
        }
        
    }

    public function actionLoadingEnd() {
        try{
            $body = @file_get_contents('php://input');
            $obj = json_decode($body);

            //$vehicleNumber = $obj->vehicleNumber;
            //$locationId = $obj->locationId;
            $loadingEnd = $obj->loadingEnd;
            $referenceId =  $obj->referenceId;

            $vehicleLoading = VehicleLoading::model()->findByPk($referenceId);
            $vehicleLoading->loadingEnd = $loadingEnd;
            $vehicleLoading->status = 2;

            if( $vehicleLoading->save()){
                $this->_sendResponse(200, CJSON::encode(array("Success"=> true)));
            }else{
                $this->_sendResponse(200, CJSON::encode(array("Success"=> false)));
            }
        }catch(Exception $e){
            $this->_sendResponse(200, CJSON::encode(array("Success"=> false,"Error"=> $e)));
        }     
    }

    public function actionArrival() {
        try{
            $body = @file_get_contents('php://input');
            $obj = json_decode($body);

            //$vehicleNumber = $obj->vehicleNumber;
            //$locationId = $obj->locationId;
            $arrivalTime = $obj->arrivalTime;
            $referenceId =  $obj->referenceId;

            $vehicleLoading = VehicleLoading::model()->findByPk($referenceId);
            $vehicleLoading->arrivalTime = $arrivalTime;
            $vehicleLoading->status = 4;

            if( $vehicleLoading->save()){
                $this->_sendResponse(200, CJSON::encode(array("Success"=> true)));
            }else{
                $this->_sendResponse(200, CJSON::encode(array("Success"=> false)));
            }
        }catch(Exception $e){
            $this->_sendResponse(200, CJSON::encode(array("Success"=> false,"Error"=> $e)));
        }     
    }

    public function actionUnloadingStart() {
        $body = @file_get_contents('php://input');
        $obj = json_decode($body);

        $vehicleNumber = $obj->vehicleNumber;
        $locationId = $obj->locationId;
        $unloadingStart = $obj->unloadingStart;

        $vehicleUnLoading = new VehicleUnloading;
        $vehicleUnLoading->vehicleNumber = $vehicleNumber;
        $vehicleUnLoading->locationId = $locationId;
        $vehicleUnLoading->unloadingStart = $unloadingStart;
        $vehicleUnLoading->status = 1;
       
        if($vehicleUnLoading->save()){
            $this->_sendResponse(200, CJSON::encode(array("Success"=> true)));
        }else{
            $this->_sendResponse(200, CJSON::encode(array("Success"=> false)));
        }
    }

    public function actionUnloadingEnd() {
        
        $body = @file_get_contents('php://input');
        $obj = json_decode($body);

        $vehicleNumber = $obj->vehicleNumber;
        $locationId = $obj->locationId;
        $unloadingEnd = $obj->unloadingEnd;

        $vehicleUnLoading = VehicleUnloading::model()->findByAttributes(array("status"=>1,"vehicleNumber"=>$vehicleNumber,"locationId"=> $locationId));
        $vehicleUnLoading->unloadingEnd = $unloadingEnd;
        $vehicleUnLoading->status = 2;

        if($vehicleUnLoading->save()){
            $this->_sendResponse(200, CJSON::encode(array("Success"=> true)));
        }else{
            $this->_sendResponse(200, CJSON::encode(array("Success"=> false)));
        }
    }

    public function actionGetAllVehicles() {
        $body = @file_get_contents('php://input');
        $obj = json_decode($body);

        //Yii::info('this is a log message', __METHOD__);
        $siteId = $obj->SiteId;

        $criteria               = new CDbCriteria;
        $criteria->select       = "t.*";
        $criteria->condition    = " t.site_id = ".$siteId."";

       
        $vehicles = Vehicle::model()->findAll($criteria);
        $this->_sendResponse(200, CJSON::encode($vehicles));
    }

    public function actionGetRoutePlan(){
        $body = @file_get_contents('php://input');
        $obj = json_decode($body);

        $vehicleNumber = $obj->vehicleNumber;
        $date = $obj->date;

        $initialPlan = InitialPlan::model()->findAllByAttributes(array("visitDate"=>$date,"vehicle"=>$vehicleNumber));

        $this->_sendResponse(200, CJSON::encode($initialPlan));
    }

    public function actionGetRouteDetails(){
        $body = @file_get_contents('php://input');
        $obj = json_decode($body);

        $siteId = $obj->SiteId;

        $sql = "SELECT * FROM `routedetails` rd INNER JOIN vehicle v ON v.vehicleNo = rd.routeDefaultVehicle WHERE v.site_id=".$siteId."";
        $routedetails = Yii::app()->db->createCommand($sql)->queryAll();
        $this->_sendResponse(200, CJSON::encode($routedetails));
    }

    public function actionDepature() {

        $body = @file_get_contents('php://input');
        $obj = json_decode($body);

        //$vehicleNumber = $obj->vehicleNumber;
        //$locationId = $obj->locationId;
        $depatureTime = $obj->depatureTime;
        $referenceId = $obj->referenceId;

        /*$vehicleDepature = new VehicleDepature;
        $vehicleDepature->vehicleNumber = $vehicleNumber;
        $vehicleDepature->locationId = $locationId;
        $vehicleDepature->depatureTime = $depatureTime;
        $vehicleDepature->status = 1;*/

        $vehicleLoading = VehicleLoading::model()->findByPk($referenceId);
        $vehicleLoading->departureTime = $depatureTime;
        $vehicleLoading->status = 3;

        if($vehicleLoading->save()){
            $this->_sendResponse(200, CJSON::encode(array("Success"=> true)));
        }else{
            $this->_sendResponse(200, CJSON::encode(array("Success"=> false)));
        }
    }

    public function actionCreateRoutePlan() {

        $body = @file_get_contents('php://input');
        $obj = json_decode($body);
        
        try{
            $vehicleNumber = $obj->vehicleNumber;
            $date = $obj->date;

            $routeDetails = $obj->routeDetails;

            RoutePlan::model()->updateAll(array("status"=>0),'vehicleNumber ="' . $vehicleNumber . '" AND date="'.$date.'"');

            foreach($routeDetails as $routeDetail){
                    
                $routePlan = new RoutePlan;
                $routePlan->vehicleNumber = $vehicleNumber;
                $routePlan->date = $date;
                $routePlan->locationId = $routeDetail->locationId;
                $routePlan->routeDescription = $routeDetail->routeDescription;
                $routePlan->save();
            }

            $this->_sendResponse(200, CJSON::encode(array("Success"=> true)));
            }catch(Exception $ex){
                Yii::log(CJSON::encode($obj),CLogger::LEVEL_ERROR);
            }
    }

    public function actionGetPlanDetails()
	{
        $body = @file_get_contents('php://input');
        $obj = json_decode($body);
        $vehicleid  = $obj->vehicleNumber;
        //$siteId = $obj->SiteId;
        $date = $obj->date;
        $sql = "SELECT rp.vehicleNumber,rp.routeDescription,rp.date,rd.name as retailerName FROM `route_plan` rp INNER JOIN  geo_locations rd on rd.retailerCode = rp.locationId  WHERE rp.date='".$date."' AND rp.status=1 AND  rp.vehicleNumber = '".$vehicleid."' ORDER BY rp.id ASC";
        $models = Yii::app()->db->createCommand($sql)->queryAll();
        
        $this->_sendResponse(200, CJSON::encode($models));
    }
    
    public function actionGetIncompleteLoadingDetails()
	{
        $body = @file_get_contents('php://input');
        $obj = json_decode($body);
        $distriborId = $obj->DistributorId;

        $sql = 'SELECT id,DATE_FORMAT(loadingStart, "%Y:%m:%d") as date, vehicleNumber, locationId, DATE_FORMAT(loadingStart, "%H:%i:%s") as loadingStart, DATE_FORMAT(loadingEnd, "%H:%i:%s") as loadingEnd,DATE_FORMAT(departureTime, "%H:%i:%s") as departureTime, status FROM vehicle_loading WHERE status != 4 AND locationId='.$distriborId.'';
        $models = Yii::app()->db->createCommand($sql)->queryAll();
        
        $this->_sendResponse(200, CJSON::encode($models));
	}
    
}

?>
