<?php

class TimesheetController extends Controller {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column1';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view', 'GetTimesheet', 'AddMOrningOT', 'EditIntime', 'SalaryRecalculate','Excel'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete'),
                'users' => array('admin'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new Timesheet;

// Uncomment the following line if AJAX validation is needed
// $this->performAjaxValidation($model);

        $users = Employee::model()->findAllByAttributes(array());

        $this->render('create', array(
            'model' => $model,'users' => $users,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

// Uncomment the following line if AJAX validation is needed
// $this->performAjaxValidation($model);

        if (isset($_POST['Timesheet'])) {
            $model->attributes = $_POST['Timesheet'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
// we only allow deletion via POST request
            $this->loadModel($id)->delete();

// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('Timesheet');
        $users = Employee::model()->findAllByAttributes(array());
        $this->render('index', array(
            'dataProvider' => $dataProvider, 'users' => $users,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new Timesheet('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Timesheet']))
            $model->attributes = $_GET['Timesheet'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = Timesheet::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'timesheet-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionGetTimesheet() {
        $Date = ($_POST['Selecteddate']);
        $employeeid = ($_POST['Selectedemployee']);
        // $Timesheet = Timesheet::model()->findByAttributes(array('date' => $Date, 'EmployeeId' => $employeeid));
        $sql = "
             SELECT 
                timesheet.id,
                timesheet.date,
                timesheet.Intime,
                timesheet.OuteTime,
                timesheet.NOvertimeHours,
                timesheet.DOverTimeHour,
                timesheet.Dovertimesalary,
                timesheet.NOvertimeSalary,
                timesheet.SallaryRate,
                timesheet.EmployeeShiftid,
                employee.Namewithini,
                employee.nic,
                designation.type,
                supplier.name AS Suppliername,
                sites.name AS sitesname

                FROM timesheet
                INNER JOIN  employee ON timesheet.EmployeeId = employee.id
                INNER JOIN designation ON employee.designationid = designation.id
                INNER JOIN supplier ON employee.supplierid = supplier.id
                INNER JOIN sites ON employee.siteid = sites.id

            WHERE timesheet.EmployeeId ='" . $employeeid . "'  AND timesheet.date ='" . $Date . "'";


        $data = Yii::app()->db->createCommand($sql)->queryAll();
        $timesheet = CJSON::encode($data);
        echo $timesheet;
    }
//============================================================================================
public function actionExcel(){
    $objPHPExcel = new PHPExcel();
    $timesheet = CJSON::decode($_POST['timesheet']);
    $checkedlist = CJSON::decode($_POST['checkedlist']);
    $employeeId = CJSON::decode($_POST['employeeId']);
    
    $row = 1;
    $row_2 = 2; 
    $col =0;
    $colNames=array("id"=>"Id","Namewithini"=>"Employee Name ","nic"=>"NIC","type"=>"Designation","Suppliername"=>"MP Supplier",
                    "sitesname"=>"Site ","date"=>"Date ","Intime"=>"In Time","OuteTime"=>"Out Time","SallaryRate"=>"Day Salary Rate",
                    "NOvertimeHours"=>"Normal OT Hour ","DOverTimeHour"=>"Normal OT Amount","NOvertimeSalary"=>"Double OT Hour",
                    "Dovertimesalary"=>"Double OT Amount","Amount"=>"Total Amount ");
    
    for($i = 0;$i < count($checkedlist);$i++){

            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col,$row,$colNames[$checkedlist[$i]]);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col,$row_2,$timesheet[0][$checkedlist[$i]]);
            $col++;
        
        
    }
    $objPHPExcel->getActiveSheet()->getStyle('A1:P1')->getFont()->setBold(true);
    
    
   
    $objPHPExcel->getActiveSheet()->setTitle($timesheet[0]['Namewithini']);
 
    $objPHPExcel->setActiveSheetIndex(0);
     
    ob_end_clean();
    ob_start();
    
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename='.$timesheet[0]['Namewithini'].'.xls');
    header('Cache-Control: max-age=0');
    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
    $objWriter->save('php://output');
  }
//============================================================================================

    public function actionEditIntime() {
        $TimeSheetid = ($_POST['id']);
        $OutTime = ($_POST['Outtime']);
        $OldOutTime = ($_POST['OldOutTime']);
        
        $outtime = date("Y-m-d H:i", strtotime($OutTime));
        
        if (!empty($TimeSheetid)) {
            if (!empty($OutTime)) {
                
                Timesheet::model()->updateAll(array('OuteTime' => $outtime), "id=" . $TimeSheetid . "");
                $Timechange = new Timsheetchange;
                $Timechange->CreatedBy = Yii::app()->user->id;
                $date = date('Y-m-d H:i:s');
                $Timechange->CreatedON = $date;
                $Timechange->OldOutTime = $OldOutTime;
                $Timechange->NewOutTime = $outtime;
                $Timechange->TimeSheetId = $TimeSheetid;
                //echo $Timechange->NewOutTime;
                $Timechange->save();
            }
        }

        echo 'Updated Successfully';
    }

    public function actionSalaryRecalculate() {
        $TimeSheetid = ($_POST['id']);

        if (!empty($TimeSheetid)) {

           Yii::app()->PayrollCalculationUtil->TimesheetRecalculate($TimeSheetid);
                             
             echo 'Recalculated Successfully ';
        }
       
    }

    public function actionAddMOrningOT() {
        echo 'aaaaa';
    }

}
