<?php

class TimelogController extends Controller {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column1';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update','Attendance','Pdf','AttendanceRange','AttendanceRangePdf','Excel'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete'),
                'users' => array('admin'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new Timelog;

// Uncomment the following line if AJAX validation is needed
// $this->performAjaxValidation($model);

        if (isset($_POST['Timelog'])) {
            
            $model->attributes = $_POST['Timelog'];
            if ($model->save()){
                Yii::app()->PayrollCalculationUtil->TimesheetCalculation($model);
                
                }
              $this->redirect(array('create'));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

// Uncomment the following line if AJAX validation is needed
// $this->performAjaxValidation($model);

        if (isset($_POST['Timelog'])) {
            $model->attributes = $_POST['Timelog'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
// we only allow deletion via POST request
            $this->loadModel($id)->delete();

// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('Timelog');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new Timelog('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Timelog']))
            $model->attributes = $_GET['Timelog'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    //=============================================================================

    public function actionAttendance() {
        $model = new AttendanceForm;

        if((isset($_POST['AttendanceForm']))){
            $model-> attributes = $_POST['AttendanceForm'];
            //validate Attendance Form
            if($model->validate()){
                //bind data 
                $model->setData();
                //die($model->employee);
                //get data from timelog model
                 $logs = Timelog::model()->findAllBySql("select * from timelog where Employeeid = ".$model->employee." AND PunchTime >=DATE('$model->startDate') AND PunchTime <= DATE('$model->endDate')");
                //get employee data from Employee model
                 $employeeDetails = Employee::model()->findByPk($model->employee);
                
                //send data to view form
                $this->render('viewAttendance',array('model'=>$model,'logs'=>$logs,'employeeDetails'=>$employeeDetails));
            

                }

        }else{
            //load CreateAttendance Form
            return $this->render('attendanceRecorde',array('model'=>$model));
        }
        
    
        
    
    }
    //=========================================================================
        public function actionAttendanceRange(){
            $model = new AttendaceRange;
            if(isset($_POST['AttendaceRange'])){
                $model-> attributes = $_POST['AttendaceRange'];
                
                if($model->validate()){
                    $list= Yii::app()->db->createCommand("SELECT T.Employeeid,D.type,E.nic,E.Namewithini,date(PunchTime) AS date1,DATE_FORMAT(MIN(PunchTime), '%H:%i:%s ') AS start , DATE_FORMAT(MAX(PunchTime), '%H:%i:%s ') AS end  FROM timelog AS T INNER JOIN employee AS E ON  T.Employeeid = E.id INNER JOIN designation AS D ON D.id = E.designationid WHERE PunchTime >=DATE('$model->startDate') AND PunchTime <= DATE('$model->endDate')
                    GROUP BY EmployeeId,date(PunchTime)")->queryAll();
                    //$attendanceRanges = Timelog::model()->findAllBySql("SELECT Employeeid,date(PunchTime) AS date1,DATE_FORMAT(MIN(PunchTime), '%h:%i:%sa') AS Start , DATE_FORMAT(MAX(PunchTime), '%h:%i:%sa') AS end  FROM timelog WHERE PunchTime >=DATE('$model->startDate') AND PunchTime <= DATE('$model->endDate') GROUP BY date(PunchTime)");
                    // print_r($attendanceRanges);
                    // die;
                    $this->render('viewAttendanceRange',array('attendanceRanges'=>$list,'model'=>$model));
                }

            }else{
                return $this->render('createAttendaceRange',array('model'=>$model));
            }
        }


    //=========================================================================
    public function actionPdf()
	{
        
            $logs = CJSON::decode($_POST['logs']);
            $employeeDetails = CJSON::decode($_POST['employee']);
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            $mPDF1->setFooter('{PAGENO}');
            $mPDF1->WriteHTML($this->renderPartial('testHtml',array('logs'=>$logs,'employeeDetails'=>$employeeDetails),true));
            $file_name= $employeeDetails['nic'].'.pdf';
            $time = date("Y-m-d  -  h:i:sa");


            $dayofweek = date('Y-m-d', strtotime('-7 days'));
            print_r($dayofweek);
            die;
            
            $mPDF1->SetFooter('Report generated by '.Yii::app()->user->name.' on ' .$time.  '<br/> powered by Eimsky Business Solutions Pvt Ltd');
            ob_end_clean();
            $mPDF1->Output($file_name,EYiiPdf::OUTPUT_TO_DOWNLOAD );
        
	}

    //=========================================================================
    public function actionAttendanceRangePdf()
	{
       
        $attendanceRanges = CJSON::decode($_POST['attendanceRanges']);
        $model = CJSON::decode($_POST['model']);
        // print_r($model);
        // die;
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->setFooter('{PAGENO}');
        $mPDF1->WriteHTML($this->renderPartial('attendanceRangePdf',array('attendanceRanges'=>$attendanceRanges),true));
        $file_name= $model['startDate'].'-'.$model['endDate'].'.pdf';
        $time = date("Y-m-d  -  h:i:sa");
        $mPDF1->SetFooter('Report generated by '.Yii::app()->user->name.' on ' .$time.  '<br> powered by Eimsky Business Solutions Pvt Ltd');
        
        
        ob_end_clean();
        $mPDF1->Output($file_name,EYiiPdf::OUTPUT_TO_DOWNLOAD );
	}

    //=========================================================================
    public function actionExcel(){
        $objPHPExcel = new PHPExcel();
        $logs = CJSON::decode($_POST['logs']);
        $employeeDetails = CJSON::decode($_POST['employee']);

        

        $objPHPExcel->setActiveSheetIndex(0)
        ->setCellValue('A1', 'date')
        ->setCellValue('B1', 'time');
        $y = 2;

        
        for($i = 0;$i < count($logs);$i++){
            
            $dateTime = new DateTime($logs[$i]['PunchTime']);
            $date = $dateTime->format('Y-m-d');
            //'h' time in 12hr
            //'H' time in 24hr
            //'a' am or pm
            $time = $dateTime->format('h:i a'); 
            $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A'.$y, $date)
            ->setCellValue('B'.$y, $time);
            $y++;
           

        }
       
        $objPHPExcel->getActiveSheet()->setTitle($employeeDetails['nic']);
     
        $objPHPExcel->setActiveSheetIndex(0);
         
        ob_end_clean();
        ob_start();
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename='.$employeeDetails['nic'].'.xls');
        header('Cache-Control: max-age=0');
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
      }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = Timelog::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'timelog-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

}
