<?php

class TeamController extends Controller {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column1';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete'),
                'users' => array('admin'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new Team;
//$models = new Employee;
        //$models = Employee::model()->findAll();
        $models = Employee::model()->findAllByAttributes(array('TeamStatus' => 0));
// Uncomment the following line if AJAX validation is needed
// $this->performAjaxValidation($model);

        if (isset($_POST['Team'])) {
            $model->attributes = $_POST['Team'];
            if ($model->save()) {
                // print_r($_POST['employees']);
                // die;
                if (isset($_POST['employees'])) {

                    foreach ($_POST['employees'] as $selectedOption) {
                        //echo $selectedOption."\n";

                        $employeeteam = new EmployeeTeam;
                        $employeeteam->teamid = $model->id;
                        $employeeteam->employeeid = $selectedOption;
                        $employeeteam->Status = 1;
                        $date = date('Y-m-d H:i:s');
                        $employeeteam->assigndate = $date;
                        $employeeteam->save();
                        Employee::model()->updateAll(array('TeamStatus' => 1), 'id="' . $selectedOption . '"');
                    }
                }
            }
            $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('create', array(
            'model' => $model, 'models' => $models,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);
           
        $sql = "
            SELECT 
            
            employee.id,
            employee.FirstName,
            employee.LastName,
            employee.Namewithini,
            employee.nic,
            employee.TeamStatus

            FROM employee_team
            INNER JOIN employee ON employee_team.employeeid = employee.id
            WHERE employee_team.teamid ='" . $id . "'  AND employee_team.Status ='" . 1 . "'";

                 
      $SEmployee = Yii::app()->db->createCommand($sql)->queryAll();
      
//      foreach ($SEmployee as $selectemployee) {
//     
//     //$selectemployee = (object)$selectemployee;
//     print_r($selectemployee['id']);
//     die;
//                          }
       // $timesheet = CJSON::encode($data);
       

        $models = Employee::model()->findAllByAttributes(array('TeamStatus' => 0));
       
// Uncomment the following line if AJAX validation is needed
// $this->performAjaxValidation($model);

        if (isset($_POST['Team'])) {
            $model->attributes = $_POST['Team'];
            if ($model->save()) {
//      EmployeeTeam::model()->deleteAllByAttributes(array(
//              'teamid' => $id,
//                ));
      $EmployeeOnTeam = EmployeeTeam::model()->findAllByAttributes(array('teamid' => $id,'Status' => 1));          
             
      foreach ($EmployeeOnTeam as $selectemployee) {

                      Employee::model()->updateAll(array('TeamStatus' => 0), 'id ="' . $selectemployee->employeeid . '"'); 
                    }
                 
                EmployeeTeam::model()->updateAll(array('Status' => 0), 'teamid="' . $id . '"');

                if (isset($_POST['employees'])) {
                    foreach ($_POST['employees'] as $selectedOption) {

                        $employeeteam = new EmployeeTeam;
                        $employeeteam->teamid = $id;
                        $employeeteam->employeeid = $selectedOption;
                        $employeeteam->Status = 1;
                        $date = date('Y-m-d H:i:s');
                        $employeeteam->assigndate = $date;
                        $employeeteam->save();
                        Employee::model()->updateAll(array('TeamStatus' => 1), 'id="' . $selectedOption . '"');
                  
                    }
                }
            }
            $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model, 'models' => $models,'SEmployee'=> $SEmployee,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
// we only allow deletion via POST request
            $this->loadModel($id)->delete();

// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('Team');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new Team('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Team']))
            $model->attributes = $_GET['Team'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = Team::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'team-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

}
