<?php

class RosterController extends Controller
{
/**
* @var string the default layout for the views. Defaults to '//layouts/column2', meaning
* using two-column layout. See 'protected/views/layouts/column2.php'.
*/
public $layout='//layouts/column1';

/**
* @return array action filters
*/
public function filters()
{
return array(
'accessControl', // perform access control for CRUD operations
);
}

/**
* Specifies the access control rules.
* This method is used by the 'accessControl' filter.
* @return array access control rules
*/
public function accessRules()
{
return array(
array('allow',  // allow all users to perform 'index' and 'view' actions
'actions'=>array('index','view','findRosterDetails','createRosterPDF','createRosterExcel'),
'users'=>array('*'),
),
array('allow', // allow authenticated user to perform 'create' and 'update' actions
'actions'=>array('create','update'),
'users'=>array('@'),
),
array('allow', // allow admin user to perform 'admin' and 'delete' actions
'actions'=>array('admin','delete'),
'users'=>array('admin'),
),
array('deny',  // deny all users
'users'=>array('*'),
),
);
}

/**
* Displays a particular model.
* @param integer $id the ID of the model to be displayed
*/
public function actionView($id)
{
$this->render('view',array(
'model'=>$this->loadModel($id),
));
}

/**
* Creates a new model.
* If creation is successful, the browser will be redirected to the 'view' page.
*/
public function actionCreate()
{
$model=new Roster;

// Uncomment the following line if AJAX validation is needed
// $this->performAjaxValidation($model);

if(isset($_POST['Roster']))
{
$model->attributes=$_POST['Roster'];
if($model->save())
$this->redirect(array('view','id'=>$model->id));
}

$this->render('create',array(
'model'=>$model,
));
}

/**
* Updates a particular model.
* If update is successful, the browser will be redirected to the 'view' page.
* @param integer $id the ID of the model to be updated
*/
public function actionUpdate($id)
{
$model=$this->loadModel($id);

// Uncomment the following line if AJAX validation is needed
// $this->performAjaxValidation($model);

if(isset($_POST['Roster']))
{
$model->attributes=$_POST['Roster'];
if($model->save())
$this->redirect(array('view','id'=>$model->id));
}

$this->render('update',array(
'model'=>$model,
));
}

/**
* Deletes a particular model.
* If deletion is successful, the browser will be redirected to the 'admin' page.
* @param integer $id the ID of the model to be deleted
*/
public function actionDelete($id)
{
if(Yii::app()->request->isPostRequest)
{
// we only allow deletion via POST request
$this->loadModel($id)->delete();

// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
if(!isset($_GET['ajax']))
$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
}
else
throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
}

/**
* Lists all models.
*/
public function actionIndex()
{
$dataProvider=new CActiveDataProvider('Roster');
$this->render('index',array(
'dataProvider'=>$dataProvider,
));
}

/**
* Manages all models.
*/
public function actionAdmin()
{
$model=new Roster('search');
$model->unsetAttributes();  // clear any default values
if(isset($_GET['Roster']))
$model->attributes=$_GET['Roster'];

$this->render('admin',array(
'model'=>$model,
));
}

/**
* Returns the data model based on the primary key given in the GET variable.
* If the data model is not found, an HTTP exception will be raised.
* @param integer the ID of the model to be loaded
*/
public function loadModel($id)
{
$model=Roster::model()->findByPk($id);
if($model===null)
throw new CHttpException(404,'The requested page does not exist.');
return $model;
}

/**
* Performs the AJAX validation.
* @param CModel the model to be validated
*/
protected function performAjaxValidation($model)
{
if(isset($_POST['ajax']) && $_POST['ajax']==='roster-form')
{
echo CActiveForm::validate($model);
Yii::app()->end();
}
}


public function actionFindRosterDetails(){
    $model = new RosterDetailsForm;
    if(isset($_POST['RosterDetailsForm'])){
          
            $model->attributes=$_POST['RosterDetailsForm'];  // only schedule is setted.         
            $model->shift=$_POST['shift'];
            $model->teams = $_POST['teams'];
            $teamsArray = $model->teams;
            $rosterSchedule = Schedule::model()->findByPk($model->schedule);
            $rosterShift = Shift::model()->findByPk($model->shift);
            $teamEmployees=array();

            foreach($teamsArray as $element){
                $teamEmployees[$element] =Employee::model()->findAllBySql("select * from employee where id in(select employeeid from employee_team where employee_team.teamid=".$element.")");
                
            }
       
            $this->render('rosterReport', array('model'=>$model,'rosterSchedule'=> $rosterSchedule,'rosterShift'=> $rosterShift,'teamEmployees'=>$teamEmployees)); 
     
}
    else{
        
        $this->render('getRosterDetailsForm', array('model'=>$model));
     }
  


}


public function actionCreateRosterPDF(){
    
     $rosterSchedule = CJSON::decode($_POST['rosterSchedule']);
     $rosterShift = CJSON::decode( $_POST['rosterShift']);
     $teamEmployees = CJSON::decode($_POST['teamEmployees']);
     $mpdf1 = Yii::app()->ePdf->mpdf();
    
    
    $mpdf1->WriteHTML($this->renderPartial('rosterPDF', array('model'=>$model,'teamEmployees'=> $teamEmployees, 'rosterSchedule'=> $rosterSchedule,'rosterShift'=> $rosterShift),true));
    $mpdf1->SetFooter("Report generated by ".Yii::app()->user->name." on ".date('Y-m-d H:i:s')."<br />powered by eIMSky Business Solutions Pvt Ltd.");

    $file_name= $rosterSchedule['Date'].'.pdf';
    
    ob_end_clean();
    
    $mpdf1->Output($file_name,EYiiPdf::OUTPUT_TO_DOWNLOAD );

 }

 public function actionCreateRosterExcel(){
    
    $objPHPExcel = new PHPExcel();
    $rosterSchedule = CJSON::decode($_POST['rosterSchedule']);
    $rosterShift = CJSON::decode( $_POST['rosterShift']);
    $teamEmployees = CJSON::decode($_POST['teamEmployees']);
            // Set document properties
            $objPHPExcel->getProperties()->setCreator("K'iin Balam")
                 ->setLastModifiedBy("K'iin Balam")
                 ->setTitle("YiiExcel Test Document")
                 ->setSubject("YiiExcel Test Document")
                 ->setDescription("Test document for YiiExcel, generated using PHP classes.")
                 ->setKeywords("office PHPExcel php YiiExcel UPNFM")
                 ->setCategory("Test result file");        
            
            // Add some data
            $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A1', 'Schedule :')
                ->setCellValue('A2', 'Shift :')
                ->setCellValue('C1', $rosterSchedule['Date'])
                ->setCellValue('C2', $rosterShift['name'])
                ->setCellValue('A4', 'Team')
                ->setCellValue('B4', 'NIC')
                ->setCellValue('C4', 'Employee ID')
                ->setCellValue('D4', 'Name');
        
            $objPHPExcel->getActiveSheet()->getStyle('A1:D4')->getFont()->setBold(true);
                $row = 5; 
                foreach($teamEmployees as $key=>$employees) {
                    $teamData = Team::model()->findByPk($key);                                                     
                             
                    foreach($employees as $employee) {
                        $col =1;
                        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, $row,$teamData->name); 
                        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col,$row,$employee['nic']);
                        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(++$col,$row,$employee['id']);
                        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(++$col,$row,$employee['FirstName']." ".$employee['LastName']);
                        $row++;
                    }
                    
                }
            
          
            $objPHPExcel->getActiveSheet()->setTitle('YiiExcel');
            $filename = $rosterSchedule['Date']." ".$rosterShift['name'];
            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="'.$filename.'.xls"');
            header('Cache-Control: max-age=0');
            
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
    
            $objWriter->save('php://output');
            unset($this->objWriter);
            unset($this->objWorksheet);
            unset($this->objReader);
            unset($this->objPHPExcel);
            exit();
        }
 
 
}
