<?php

class RosterApiController extends Controller {

    Const APPLICATION_ID = 'ASCCPE';

    /**
     * Default response format
     * either 'json' or 'xml'
     */
    private $format = 'json';

    /**
     * @return array action filters
     */
    public function filters() {
        return array();
    }

    public function actionShiftCreate() {

        $body = @file_get_contents('php://input');
        $obj = json_decode($body);

        $Schedulemodel = new Schedule;
        $rostermodel = new Roster;

        $startdate = $obj->StartDate;
        $Roster = Roster::model()->findByAttributes(array('StartDate' => $startdate));

        if (empty($Roster)) {
            $response = array();
            $rostermodel->StartDate = $obj->StartDate;
            $rostermodel->EndDate = $obj->EndDate;

            if ($rostermodel->save()) {
                $Schedulemodel->rosterid = $rostermodel->id;
                $Schedulemodel->Date = $obj->date;
                if ($Schedulemodel->save()) {

                    foreach ($obj->shift as $shiftmodule) {

                        $shiftmodel = new Shift;
                        $shiftmodel->StartTime = $shiftmodule->starttime;
                        $shiftmodel->EndTime = $shiftmodule->endtime;
                        $shiftmodel->schedulid = $Schedulemodel->id;
                        $shiftmodel->name = $shiftmodule->Shiftname;
                        $shiftmodel->salaryRate = $shiftmodule->salaryRate;
                        $shiftmodel->FirstOTRate = $shiftmodule->FirstOTRate;
                        $shiftmodel->SecondOTRate = $shiftmodule->SecondOTRate;
                        $shiftmodel->FirstOTTimeRang = $shiftmodule->FirstOTTimeRang;
                        $shiftmodel->SecondOTRange = $shiftmodule->SecondOTRange;

                        if($shiftmodel->save()){
                            $response[] = $shiftmodel;
                        }
                    }
                }
            }

             $this->_sendResponse(200, CJSON::encode($response));
        } else {


            $Schedul = Schedule::model()->findByAttributes(array('Date' => $obj->date));
            if (empty($Schedul)) {
                $response2 = array();
                $Schedulemodel->rosterid = $Roster->id;
                $Schedulemodel->Date = $obj->date;

                if ($Schedulemodel->save()) {

                    foreach ($obj->shift as $shiftmodule) {

                        $shiftmodel = new Shift;
                        $shiftmodel->StartTime = $shiftmodule->starttime;
                        $shiftmodel->EndTime = $shiftmodule->endtime;
                        $shiftmodel->schedulid = $Schedulemodel->id;
                        $shiftmodel->name = $shiftmodule->Shiftname;
                        $shiftmodel->salaryRate = $shiftmodule->salaryRate;
                        $shiftmodel->FirstOTRate = $shiftmodule->FirstOTRate;
                        $shiftmodel->SecondOTRate = $shiftmodule->SecondOTRate;
                        $shiftmodel->FirstOTTimeRang = $shiftmodule->FirstOTTimeRang;
                        $shiftmodel->SecondOTRange = $shiftmodule->SecondOTRange;

                        if($shiftmodel->save()){
                             $response2[] = $shiftmodel;
                        }
                    }
                }
                $this->_sendResponse(200, CJSON::encode($response2));
            } else {
                $response3 = array();
                $schedulid = $Schedul->id;
                foreach ($obj->shift as $shiftmodule) {

                    $shiftmodel = new Shift;
                    $shiftmodel->StartTime = $shiftmodule->starttime;
                    $shiftmodel->EndTime = $shiftmodule->endtime;
                    $shiftmodel->schedulid = $schedulid;
                    $shiftmodel->name = $shiftmodule->Shiftname;
                    $shiftmodel->salaryRate = $shiftmodule->salaryRate;
                    $shiftmodel->FirstOTRate = $shiftmodule->FirstOTRate;
                    $shiftmodel->SecondOTRate = $shiftmodule->SecondOTRate;
                    $shiftmodel->FirstOTTimeRang = $shiftmodule->FirstOTTimeRang;
                    $shiftmodel->SecondOTRange = $shiftmodule->SecondOTRange;
                    
                if( $shiftmodel->save()){
                    $response3[] = $shiftmodel;
                }
                }
                $this->_sendResponse(200, CJSON::encode($response3));
            }
        }
    }

// Add team to shift and created record to employee_shift model
    public function actionTeamshftCreate() {

        $body = @file_get_contents('php://input');
        $obj = json_decode($body);
        $shiftid = $obj->shiftid;
        $schedulid = $obj->schedulid;
        $Team = $obj->teamid;

      //  foreach ($Team as $selectedOption) {
            $TeamShift = new TeamShift;
            $TeamShift->shiftid = $shiftid;
            $TeamShift->teamid = $Team;
            $TeamShift->Status = 1;
            $date = date('Y-m-d H:i:s');
            $TeamShift->time = $date;
            $TeamShift->shedulid = $schedulid;


            if ($TeamShift->save()) {
                
                $employee = EmployeeTeam::model()->findAllByAttributes(array('teamid' => $TeamShift->teamid, 'Status' => 1));
                 
                foreach ($employee as $employeelist) {

                    $EmployeeShift = new EmployeeShift;
                    $EmployeeShift->EmployeeId = $employeelist->employeeid;
                    $EmployeeShift->ShiftId = $TeamShift->shiftid;
                    $EmployeeShift->TeamId = $TeamShift->teamid;
                    $EmployeeShift->Status = 1;
                    $date = date('Y-m-d H:i:s');
                    $EmployeeShift->DateTime = $date;
                    $EmployeeShift->schedulid = $TeamShift->shedulid;
                    if($EmployeeShift->save()){
                       
                        //======Start timesheet create======// 
                        $Shedul = Schedule::model()->findByAttributes(array('id' => $EmployeeShift->schedulid));
                        
                        $SheduleDate = $Shedul->Date;
                        
                        $IntimeTimelog = Yii::app()->PayrollCalculationUtil->GetStartTimeLOg($SheduleDate,$EmployeeShift->EmployeeId);
                       
                        if (!empty($IntimeTimelog)){
                             
                              $LasttimeTimelog = Yii::app()->PayrollCalculationUtil->GetEndTimeLOg($SheduleDate,$EmployeeShift->EmployeeId);
                              Yii::app()->PayrollCalculationUtil->TimesheetCreateByshift($EmployeeShift,$IntimeTimelog,$LasttimeTimelog,$SheduleDate);
                              
                        }     
                         //======end timesheet create======// 
                    }
                   
                }
            }
     

        $this->_sendResponse(200, CJSON::encode($EmployeeShift));
    }

    public function actionTeamdelete() {

        $body = @file_get_contents('php://input');
        $obj = json_decode($body);
        $shiftid = $obj->shiftid;
        $teamid = $obj->teamid;

       // $employee = EmployeeTeam::model()->findAllByAttributes(array('teamid' => $teamid));


        //foreach ($employee as $employeeid) {
             // }

        EmployeeShift::model()->deleteAllByAttributes(array('ShiftId' => $shiftid, 'TeamId' => $teamid));
        TeamShift::model()->deleteAllByAttributes(array('shiftid' => $shiftid, 'teamid' => $teamid));
      

        
        $this->_sendResponse(200, CJSON::encode("delete sucsess"));
    }

    public function actionShiftdelete() {

        $body = @file_get_contents('php://input');
        $obj = json_decode($body);
        $shiftid = $obj->shiftid;
        $Teamshift = TeamShift::model()->findAllByAttributes(array('shiftid' => $shiftid));

        foreach ($Teamshift as $teamshift) {

            $employee = EmployeeTeam::model()->findAllByAttributes(array('teamid' => $teamshift->teamid));

            foreach ($employee as $employeeid) {
                EmployeeShift::model()->deleteAllByAttributes(array('EmployeeId' => $employeeid->employeeid, 'ShiftId' => $shiftid));
            }

            TeamShift::model()->deleteAllByAttributes(array('shiftid' => $shiftid));
        }

        Shift::model()->deleteAllByAttributes(array('id' => $shiftid));
        $this->_sendResponse(200, CJSON::encode("deleted shift"));
    }


    // All teams in created shift.
    public function actionGetAllTeamesCreated() {

        $body = @file_get_contents('php://input');
        $obj = json_decode($body);
        $shiftid = $obj->shiftid;
        $sql = "
             SELECT
            employee.id AS employeeid,
            employee.Namewithini,
            employee.nic,
            team.id AS Teamid,
            team.name AS TeamName,
            employee_shift.ShiftId,
            employee_shift.schedulid

            FROM employee_shift
            INNER JOIN employee ON employee_shift.EmployeeId = employee.id
            INNER JOIN team ON employee_shift.TeamId = team.id

            WHERE employee_shift.ShiftId ='" . $shiftid . "'";


        $teams = Yii::app()->db->createCommand($sql)->queryAll();

        if (empty($teams)) {

            $this->_sendResponse(200, CJSON::encode($teams));
        } else {

            $this->_sendResponse(200, CJSON::encode($teams));
        }
    }
//All shift in the roster
    public function actionGetAllShifts() {
        $body = @file_get_contents('php://input');
        $obj = json_decode($body);

        $starttime = $obj->StartDate;
        $endtime = $obj->EndDate;

        $sql = "SELECT
                NOW() AS CurrentTime,
                shift.id,
                shift.StartTime,
                shift.EndTime,
                shift.name,
                schedule.id AS ScheduleId ,
                schedule.date AS ScheduleDate,
                roster.id AS RosterId

         FROM
                shift
         INNER JOIN
                schedule ON shift.schedulid = schedule.id
         INNER JOIN
                roster ON schedule.rosterid = roster.id

        WHERE roster.StartDate ='" . $starttime . "' AND roster.EndDate ='" . $endtime . "'";

        $shifts = Yii::app()->db->createCommand($sql)->queryAll();
        
        //$sql1 = "SELECT  NOW() AS CurrentTime";
        //$CurrentDate = Yii::app()->db->createCommand($sql1)->queryAll();  
       
        if (empty($shifts)) {
            

            $this->_sendResponse(200, CJSON::encode($shifts));
        } else {

            $this->_sendResponse(200, CJSON::encode($shifts));
        }
    }

    public function actionGetAllTeams() {
        $models = Team::model()->findAll();

        if (empty($models)) {

            $this->_sendResponse(200, sprintf($models));
        } else {
            $rows = array();
            foreach ($models as $model)
                $rows[] = $model->attributes;
                $this->_sendResponse(200, CJSON::encode($rows));
        }
    }

    public function actionGetAllEmployeeByTeem() {
        $body = @file_get_contents('php://input');
        $obj = json_decode($body);
        $teamid = $obj->teamid;

        $sql = "
            SELECT
            employee.id AS Employeeid,
            employee.Namewithini,
            employee.nic

            FROM
                employee_team

            INNER JOIN employee ON employee_team.employeeid = employee.id
            WHERE employee_team.teamid ='" . $teamid . "' AND employee_team.Status ='" . 1 . "'" ;


        $employees = Yii::app()->db->createCommand($sql)->queryAll();

        if (empty($employees)) {

            $this->_sendResponse(200, CJSON::encode($employees));
        } else {

            $this->_sendResponse(200, CJSON::encode($employees));
        }

    }
   public function actionGetAllHolidays() {
        $body = @file_get_contents('php://input');
        $obj = json_decode($body);
        $starttime = $obj->StartDate;
        $endtime = $obj->EndDate;

        $sql = "
            SELECT *
            FROM holydays
            WHERE    
            holydays.Date >= '" . $starttime ."' AND holydays.Date <= '". $endtime ."'" ;


        $Holidays = Yii::app()->db->createCommand($sql)->queryAll();

        if (empty($Holidays)) {

            $this->_sendResponse(200, CJSON::encode($Holidays));
        } else {

            $this->_sendResponse(200, CJSON::encode($Holidays));
        }

    }
   public function actionGetDayRate() {
        $body = @file_get_contents('php://input');
        $obj = json_decode($body);
        $TDAT = $obj->date;
        
        $Rates = Yii::app()->HolidayRateUtil->getRates($TDAT);
        if (empty($Rates)) {

            $this->_sendResponse(200, CJSON::encode($Rates));
        } else {

            $this->_sendResponse(200, CJSON::encode($Rates));
        }

    }
   /*private function _sendResponse($status = 200, $body = '', $content_type = 'text/html') {
        $status_header = 'HTTP/1.1 ' . $status . ' ' . $this->_getStatusCodeMessage($status);
        // set the status
        header($status_header);
        // set the content type
        header('Content-type: ' . $content_type);

        // pages with body are easy
        if ($body != '') {
            // send the body
            echo $body;
            exit;
        }
        // we need to create the body if none is passed
        else {
            // create some body messages
            $message = '';
            switch ($status) {
                case 401:
                    $message = 'You must be authorized to view this page.';
                    break;
                case 404:
                    $message = 'The requested URL ' . $_SERVER['REQUEST_URI'] . ' was not found.';
                    break;
                case 500:
                    $message = 'The server encountered an error processing your request.';
                    break;
                case 501:
                    $message = 'The requested method is not implemented.';
                    break;
            }

            // servers don't always have a signature turned on (this is an apache directive "ServerSignature On")
            $signature = ($_SERVER['SERVER_SIGNATURE'] == '') ? $_SERVER['SERVER_SOFTWARE'] . ' Server at ' . $_SERVER['SERVER_NAME'] . ' Port ' . $_SERVER['SERVER_PORT'] : $_SERVER['SERVER_SIGNATURE'];

            // this should be templatized in a real-world solution
            $body = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
                        <html>
                            <head>
                                <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
                                <title>' . $status . ' ' . $this->_getStatusCodeMessage($status) . '</title>
                            </head>
                            <body>
                                <h1>' . $this->_getStatusCodeMessage($status) . '</h1>
                                <p>' . $message . '</p>
                                <hr />
                                <address>' . $signature . '</address>
                            </body>
                        </html>';

            echo $body;
            exit;
        }
    }

    private function _getStatusCodeMessage($status) {

        // for an example
        $codes = Array(
            100 => 'Continue',
            101 => 'Switching Protocols',
            200 => 'OK',
            201 => 'Created',
            202 => 'Accepted',
            203 => 'Non-Authoritative Information',
            204 => 'No Content',
            205 => 'Reset Content',
            206 => 'Partial Content',
            300 => 'Multiple Choices',
            301 => 'Moved Permanently',
            302 => 'Found',
            303 => 'See Other',
            304 => 'Not Modified',
            305 => 'Use Proxy',
            306 => '(Unused)',
            307 => 'Temporary Redirect',
            400 => 'Bad Request',
            401 => 'Unauthorized',
            402 => 'Payment Required',
            403 => 'Forbidden',
            404 => 'Not Found',
            405 => 'Method Not Allowed',
            406 => 'Not Acceptable',
            407 => 'Proxy Authentication Required',
            408 => 'Request Timeout',
            409 => 'Conflict',
            410 => 'Gone',
            411 => 'Length Required',
            412 => 'Precondition Failed',
            413 => 'Request Entity Too Large',
            414 => 'Request-URI Too Long',
            415 => 'Unsupported Media Type',
            416 => 'Requested Range Not Satisfiable',
            417 => 'Expectation Failed',
            500 => 'Internal Server Error',
            501 => 'Not Implemented',
            502 => 'Bad Gateway',
            503 => 'Service Unavailable',
            504 => 'Gateway Timeout',
            505 => 'HTTP Version Not Supported'
        );

        return (isset($codes[$status])) ? $codes[$status] : '';
    }*/

}
