<?php

class LoginApiController extends Controller
{
    // Members
    /**
     * Key which has to be in HTTP USERNAME and PASSWORD headers 
     */
    Const APPLICATION_ID = 'ASCCPE';
 
    /**
     * Default response format
     * either 'json' or 'xml'
     */
    private $format = 'json';
    /**
     * @return array action filters
     */
    public function filters()
    {
            return array();
    }
	
	public function actionLogin()
    {
        $body = @file_get_contents('php://input');
	
	    $obj = json_decode($body);

        $username = $obj->username;
        $password = $obj->password;
     
         // Check if the USERNAME and PASSWORD are empty?
        if($username == '' or $password == '') {
            // Error: Unauthorized
            $this->_sendResponse(401,'Error: Invalid Username or Password');
        }
          
		$identity = new YumUserIdentity($username, $password);
       
		$identity->authenticate();
        
		if(empty($identity->user)){
			 $this->_sendResponse(200,   CJSON::encode(array( "Status"=> false)));
		}else{
            $site = Sites::model()->findByPk($identity->user->SiteId);
            $this->_sendResponse(200, 
                CJSON::encode(array(
                    "id"=>$identity->user->id,
                    "username"=>$identity->user->username,
                    "superuser"=>$identity->user->superuser,
                    "status"=>$identity->user->status,
                    "employeeNo"=>$identity->user->employeeNo,
                    "SiteId"=>$identity->user->SiteId,
                    "DistributorId"=>$site->distributorId,
                    "Status"=> true
                ))
            );
		}
    }
    
 
    /**
     * Checks if a request is authorized
     * 
     * @access private
     * @return void
     */
    private function _checkAuth()
    {
        //Get the header values for username & password
        $username = $this->GetHeader('HTTP_X_'.self::APPLICATION_ID.'_USERNAME');
        $password = $this->GetHeader('HTTP_X_'.self::APPLICATION_ID.'_PASSWORD');
                     
        // Check if the USERNAME and PASSWORD are empty?
        if($username == '' or $password == '') {
            // Error: Unauthorized
            $this->_sendResponse(401);
        }
        // Find the user
        $user=User::model()->find('LOWER(username)=?',array(strtolower($username)));
        if($user===null) {
            // Error: Unauthorized
            $this->_sendResponse(401, 'Error: User Name is invalid');
        } else if(!$user->validatePassword($password)) {
            // Error: Unauthorized
            $this->_sendResponse(401, 'Error: User Password is invalid');
        }
    }// }}} 
    //
    //
    // {{{ _getObjectEncoded
    /**
     * Returns the json or xml encoded array
     * 
     * @param mixed $model 
     * @param mixed $array Data to be encoded
     * @access private
     * @return void
     */
    private function _getObjectEncoded($model, $array)
    {
        if(isset($_GET['format']))
            $this->format = $_GET['format'];

        if($this->format=='json')
        {
            return CJSON::encode($array);
        }
        elseif($this->format=='xml')
        {
            $result = '<?xml version="1.0">';
            $result .= "\n<$model>\n";
            foreach($array as $key=>$value)
                $result .= "    <$key>".utf8_encode($value)."</$key>\n"; 
            $result .= '</'.$model.'>';
            return $result;
        }
        else
        {
            return;
        }
    } 
    
    private function GetHeader($myheader)
    {
        if (isset($_SERVER[$myheader])) {
          return $_SERVER[$myheader];
        } else {
          $headers = apache_request_headers();
          if (isset($headers[$myheader])) {
            return $headers[$myheader];
          }
        }
        return '';
     }
}

?>
