<?php

class GatepassItemsController extends Controller
{
/**
* @var string the default layout for the views. Defaults to '//layouts/column2', meaning
* using two-column layout. See 'protected/views/layouts/column2.php'.
*/
public $layout='//layouts/column1';

/**
* @return array action filters
*/
public function filters()
{
return array(
'accessControl', // perform access control for CRUD operations
);
}

/**
* Specifies the access control rules.
* This method is used by the 'accessControl' filter.
* @return array access control rules
*/
public function accessRules()
{
return array(
array('allow',  // allow all users to perform 'index' and 'view' actions
'actions'=>array('index','view','GetGatepassItemsUsingAssetid'),
'users'=>array('*'),
),
array('allow', // allow authenticated user to perform 'create' and 'update' actions
'actions'=>array('create','update'),
'users'=>array('@'),
),
array('allow', // allow admin user to perform 'admin' and 'delete' actions
'actions'=>array('admin','delete'),
'users'=>array('admin'),
),
array('deny',  // deny all users
'users'=>array('*'),
),
);
}

/**
* Displays a particular model.
* @param integer $id the ID of the model to be displayed
*/
public function actionView($id)
{
$this->render('view',array(
'model'=>$this->loadModel($id),
));
}

/**
* Creates a new model.
* If creation is successful, the browser will be redirected to the 'view' page.
*/
public function actionCreate()
{
$model=new GatepassItems;

// Uncomment the following line if AJAX validation is needed
// $this->performAjaxValidation($model);

if(isset($_POST['GatepassItems']))
{
$model->attributes=$_POST['GatepassItems'];
if($model->save())
$this->redirect(array('view','id'=>$model->id));
}

$this->render('create',array(
'model'=>$model,
));
}

/**
* Updates a particular model.
* If update is successful, the browser will be redirected to the 'view' page.
* @param integer $id the ID of the model to be updated
*/
public function actionUpdate($id)
{
$model=$this->loadModel($id);

// Uncomment the following line if AJAX validation is needed
// $this->performAjaxValidation($model);

if(isset($_POST['GatepassItems']))
{
$model->attributes=$_POST['GatepassItems'];
if($model->save())
$this->redirect(array('view','id'=>$model->id));
}

$this->render('update',array(
'model'=>$model,
));
}

/**
* Deletes a particular model.
* If deletion is successful, the browser will be redirected to the 'admin' page.
* @param integer $id the ID of the model to be deleted
*/
public function actionDelete($id)
{
if(Yii::app()->request->isPostRequest)
{
// we only allow deletion via POST request
$this->loadModel($id)->delete();

// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
if(!isset($_GET['ajax']))
$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
}
else
throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
}

/**
* Lists all models.
*/
public function actionIndex()
{
$dataProvider=new CActiveDataProvider('GatepassItems');
$this->render('index',array(
'dataProvider'=>$dataProvider,
));
}

/**
* Manages all models.
*/
public function actionAdmin()
{
$model=new GatepassItems('search');
$model->unsetAttributes();  // clear any default values
if(isset($_GET['GatepassItems']))
$model->attributes=$_GET['GatepassItems'];

$this->render('admin',array(
'model'=>$model,
));
}

/**
* Returns the data model based on the primary key given in the GET variable.
* If the data model is not found, an HTTP exception will be raised.
* @param integer the ID of the model to be loaded
*/
public function loadModel($id)
{
$model=GatepassItems::model()->findByPk($id);
if($model===null)
throw new CHttpException(404,'The requested page does not exist.');
return $model;
}

/**
* Performs the AJAX validation.
* @param CModel the model to be validated
*/
protected function performAjaxValidation($model)
{
if(isset($_POST['ajax']) && $_POST['ajax']==='gatepass-items-form')
{
echo CActiveForm::validate($model);
Yii::app()->end();
}
}
//+++++++++++++++++++++++++++API+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

public function actionGetGatepassItemsUsingAssetid(){
    $body = @file_get_contents('php://input');
    $obj = json_decode($body);

    $itemForGatepassId = Yii::app()->db->createCommand("SELECT IFG.id FROM items_for_gatepass IFG WHERE IFG.status = 5 AND IFG.assetId IN (SELECT asset.id FROM asset WHERE asset.uid = '".$obj->assetUid."')")->queryScalar();
    if(!empty($itemForGatepassId)){

        ItemsForGatepass::model()->updateByPk($itemForGatepassId,array('status'=>10));

        Yii::app()->db->createCommand("UPDATE gatepass_items GI
        SET GI.status = 8 
        WHERE GI.status = 7 AND GI.item_for_gatepass_id = $itemForGatepassId")->execute();

        $gatepassId = Yii::app()->db->createCommand("SELECT GI.gatepassId FROM gatepass_items GI WHERE GI.item_for_gatepass_id = $itemForGatepassId")->queryScalar();

        $gatepassItems = Yii::app()->db->createCommand("SELECT gatepass_items.*,at.name,a.id assetId,a.uid 
            FROM gatepass_items
            INNER JOIN items_for_gatepass ON items_for_gatepass.id = gatepass_items.item_for_gatepass_id
            inner join asset a on a.id = items_for_gatepass.assetId
            inner join assettypes at on at.id = a.type
            WHERE gatepass_items.gatepassId = $gatepassId")->queryAll();

        $totalItemsInGatepass = Yii::app()->db->createCommand("SELECT COUNT(*) FROM gatepass_items GI WHERE GI.gatepassId = $gatepassId")->queryAll();
        $totalReturnedItemsInGatepass = Yii::app()->db->createCommand("SELECT COUNT(*) FROM gatepass_items GI WHERE GI.gatepassId = $gatepassId AND GI.status = 8")->queryAll();

        if($totalItemsInGatepass == $totalReturnedItemsInGatepass){
            GatePass::model()->updateByPk($gatepassId,array('status'=>10));
            
        }
        $this->_sendResponse(200,CJSON::encode($gatepassItems));
        
    }else{
        $this->_sendResponse(200,CJSON::encode(array('status'=>false)));
    }
    
}

}
