<?php

class GatePassController extends Controller
{
/**
* @var string the default layout for the views. Defaults to '//layouts/column2', meaning
* using two-column layout. See 'protected/views/layouts/column2.php'.
*/
public $layout='//layouts/column1';

/**
* @return array action filters
*/
public function filters()
{
return array(
'accessControl', // perform access control for CRUD operations
);
}

/**
* Specifies the access control rules.
* This method is used by the 'accessControl' filter.
* @return array access control rules
*/
public function accessRules()
{
return array(
array('allow',  // allow all users to perform 'index' and 'view' actions
'actions'=>array('index','view','Contact','ViewGatepass','DownloadGatepass','GetGatepass','RejectGatepass','AcceptGatepass','ReleaseGatepass','ReturnGatepassItems'),
'users'=>array('*'),
),
array('allow', // allow authenticated user to perform 'create' and 'update' actions
'actions'=>array('create','update'),
'users'=>array('@'),
),
array('allow', // allow admin user to perform 'admin' and 'delete' actions
'actions'=>array('admin','delete'),
'users'=>array('admin'),
),
array('deny',  // deny all users
'users'=>array('*'),
),
);
}

/**
* Displays a particular model.
* @param integer $id the ID of the model to be displayed
*/
public function actionView($id)
{
$this->render('view',array(
'model'=>$this->loadModel($id),
));
}

/**
* Creates a new model.
* If creation is successful, the browser will be redirected to the 'view' page.
*/
public function actionCreate()
{
    $model=new GatePass;
    $items = Yii::app()->db->createCommand("SELECT IFG.id,AT.name type,A.serial,A.uid,A.id assetId
            FROM items_for_gatepass IFG
            INNER JOIN asset A ON A.id = IFG.assetId
            INNER JOIN assettypes AT ON AT.id = A.type
            WHERE IFG.status = 4")->queryAll();



    if(isset($_POST['GatePass']))
    {
      
    $model->attributes=$_POST['GatePass'];
    $model->status = 1;
    $model->CreatedOn = date("Y-m-d h:m:s");
    $model->CreatedBy = Yii::app()->user->getId(); 

    if($model->save()){

        if(isset($_POST['actions'])){
            foreach($_POST['actions'] as $item){
                $gItem = new GatepassItems;
                ItemsForGatepass::model()->updateByPk($item,array('status'=>5));
                $gItem->gatepassId = $model->id;
                $gItem->item_for_gatepass_id = $item;
                $gItem->status = 6;
                $gItem->save();
                
            }
        }
        $selectItems = Yii::app()->db->createCommand("SELECT A.*,AT.name
            FROM asset A
            INNER JOIN assettypes AT ON AT.id = A.type
            WHERE A.id IN (SELECT IP.assetId FROM items_for_gatepass IP WHERE IP.id IN (".implode(',',$_POST['actions']).") )")->queryAll();

        $this->render('viewGatepass',array('model'=>$model,'selectItems'=>$selectItems,));
        die;
    }
        
    }

    $this->render('create',array(
    'model'=>$model,'items'=>$items,
    ));
}

//==========================================================
public function actionContact()
{
            $modelId = $_POST['model'];
            $personName = $_POST['person'];
            $url = Yii::app()->getBaseUrl(true).'/index.php/GatePass/ViewGatepass/'.$modelId;
            $mail = new YiiMailer('contact', array('gatepass' => $modelId, 'name' => $personName, 'description' => 'Gate Pass','url'=>$url));
            $mail->setFrom('thilinamx@gmail.com', 'SATS');
            $mail->setSubject('Pending Approval for gate pass');
            $mail->setTo(Yii::app()->params['adminEmail']);
            $mail->SMTPOptions = array(
                'ssl' => array(
                    'verify_peer' => false,
                    'verify_peer_name' => false,
                    'allow_self_signed' => true
                )
            );
            
           // echo $mail->Host;
           // die;
           // $mail->setSmtp('smtp.gmail.com', 465, 'ssl', true, 'achinilv@gmail.com', '921841310');
            //send
            if ($mail->send()) {
                echo 'Success';
                //Yii::app()->user->setFlash('contact','Thank you for contacting us. We will respond to you as soon as possible.');
            } else {
                //CJSON::encode($mail->getError());
                //echo 'Failed';
                //Yii::app()->user->setFlash('error','Error while sending email: '.$mail->getError());
            }
            die;
            
           $this->refresh();
        
    
    
}
//========================================================

/**
* Updates a particular model.
* If update is successful, the browser will be redirected to the 'view' page.
* @param integer $id the ID of the model to be updated
*/
public function actionUpdate($id)
{
$model=$this->loadModel($id);

// Uncomment the following line if AJAX validation is needed
// $this->performAjaxValidation($model);

if(isset($_POST['GatePass']))
{
$model->attributes=$_POST['GatePass'];
if($model->save())
$this->redirect(array('view','id'=>$model->id));
}

$this->render('update',array(
'model'=>$model,
));
}

/**
* Deletes a particular model.
* If deletion is successful, the browser will be redirected to the 'admin' page.
* @param integer $id the ID of the model to be deleted
*/
public function actionDelete($id)
{
if(Yii::app()->request->isPostRequest)
{
// we only allow deletion via POST request
$this->loadModel($id)->delete();

// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
if(!isset($_GET['ajax']))
$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
}
else
throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
}

/**
* Lists all models.
*/
public function actionIndex()
{
$dataProvider=new CActiveDataProvider('GatePass');
$this->render('index',array(
'dataProvider'=>$dataProvider,
));
}

/**
* Manages all models.
*/
public function actionAdmin()
{
$model=new GatePass('search');
$model->unsetAttributes();  // clear any default values
if(isset($_GET['GatePass']))
$model->attributes=$_GET['GatePass'];

$this->render('admin',array(
'model'=>$model,
));
}

/**
* Returns the data model based on the primary key given in the GET variable.
* If the data model is not found, an HTTP exception will be raised.
* @param integer the ID of the model to be loaded
*/
public function loadModel($id)
{
$model=GatePass::model()->findByPk($id);
if($model===null)
throw new CHttpException(404,'The requested page does not exist.');
return $model;
}

/**
* Performs the AJAX validation.
* @param CModel the model to be validated
*/
protected function performAjaxValidation($model)
{
if(isset($_POST['ajax']) && $_POST['ajax']==='gate-pass-form')
{
echo CActiveForm::validate($model);
Yii::app()->end();
}
}

//==================================================================

    public function actionViewGatepass($id){
        $gatepassDetails = GatePass::model()->findByPk($id);
        $items = Yii::app()->db->createCommand("SELECT A.* ,AT.name,GI.status itemForGatepassStatus
        FROM gatepass_items GI
        INNER JOIN items_for_gatepass IG ON IG.id = GI.item_for_gatepass_id
        INNER JOIN asset A ON A.id = IG.assetId
        INNER JOIN assettypes AT ON AT.id = A.type 
        WHERE GI.gatepassId = $id")->queryAll();
        
        $this->render('approvedGatepass',array('model'=>$gatepassDetails,'selectItems'=>$items));
    }

    public function actionDownloadGatepass(){
        $selectItems = CJSON::decode($_POST['selectItems']);
        $model = json_decode($_POST['model']);
        GatePass::model()->updateByPk($model->id,array('status'=>2));
        // print_r($selectItems);
        // die;
        
        $width  = 200;  
        //Height of the barcode image.
        $height = 100;
        //Quality of the barcode image. Only for JPEG.
        $quality = 100;
        //1 if text should appear below the barcode. Otherwise 0.
        $text =1;
        // Location of barcode image storage.
        $location = Yii::getPathOfAlias("webroot").'/barcode/'.$model->id.'.jpeg';
        // print_r($location);
        // die;
        
        Yii::import("application.extensions.barcode1.*");                      
        barcode::Barcode39($model->id, $width , $height , $quality, $text, $location);
        // echo "ok";
        // die;

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->setAutoBottomMargin = 'stretch';
        $mPDF1->SetFooter('Powered By Eimsky Business Solutions Pvt Ltd <br> Page {PAGENO} of {nb}');
        $mPDF1->WriteHTML($this->renderPartial('gatepassPDF',array('model'=>$model,'selectItems'=>$selectItems),true));
        $file_name= 'Personal Report.'.'pdf';
        
        
        ob_end_clean();
        $mPDF1->Output();
    }

    public function actionRejectGatepass(){
        $model = json_decode($_POST['model']);
        GatePass::model()->updateByPk($model,array('status'=>3));
        echo true;

    }

    public function actionAcceptGatepass(){
        $model = json_decode($_POST['model']);
        GatePass::model()->updateByPk($model,array('status'=>2));
        echo true;

    }
//+++++++++++++++++++++++++++++++++++++++++++++++++++++API++++++++++++++++++++++++++++++++++++++++++++++++++++
    public function actionGetGatepass(){
        $body = @file_get_contents('php://input');
        $obj = json_decode($body);

        $items = Yii::app()->db->createCommand("SELECT A.*,AT.name
            FROM gatepass_items G
            INNER JOIN items_for_gatepass IG ON IG.id = G.item_for_gatepass_id
            INNER JOIN asset A ON A.id = IG.assetId
            INNER JOIN assettypes AT on AT.id = A.type
            WHERE G.gatepassId = $obj->gatepassId")->queryAll();

        if(count($items) != 0){
            $this->_sendResponse(200,CJSON::encode($items));
        }else{
            $this->_sendResponse(200,CJSON::encode(array('status'=>0)));
        }
    }

    public function actionReleaseGatepass(){
        $body = @file_get_contents('php://input');
        $obj = json_decode($body);

        $gatepassId = $obj->gatePassId;
        $productsIds = $obj->products;
        

        foreach($productsIds as $productId=>$a){
            $itemForGatepassId = Yii::app()->db->createCommand("SELECT IFG.id FROM items_for_gatepass IFG WHERE IFG.assetId = $a->productId AND IFG.status = 5")->queryScalar();
            
            $aa = Yii::app()->db->createCommand("UPDATE gatepass_items  GI
            SET GI.status = 7
            WHERE GI.gatepassId = $gatepassId AND GI.item_for_gatepass_id = $itemForGatepassId")->execute();
            
        }

        GatePass::model()->updateByPk($gatepassId,array('status'=>9));

    $this->_sendResponse(200,CJSON::encode(array('status'=>true)));
    }
public function actionReturnGatepassItems(){
    $body = @file_get_contents('php://input');
        $obj = json_decode($body);

        $gatepassId = $obj->gatePassId;
        $productsIds = $obj->products;

        foreach($productsIds as $productId=>$a){
            $itemForGatepassId = Yii::app()->db->createCommand("SELECT IFG.id FROM items_for_gatepass IFG WHERE IFG.assetId = $a->productId AND IFG.status = 5")->queryScalar();
            
            $aa = Yii::app()->db->createCommand("UPDATE gatepass_items  GI
            SET GI.status = 8
            WHERE GI.gatepassId = $gatepassId AND GI.item_for_gatepass_id = $itemForGatepassId")->execute();
            
        }

    $totalItemsInGatepass = Yii::app()->db->createCommand("SELECT COUNT(*) FROM gatepass_items GI WHERE GI.gatepassId = $gatepassId")->queryAll();
    $totalReturnedItemsInGatepass = Yii::app()->db->createCommand("SELECT COUNT(*) FROM gatepass_items GI WHERE GI.gatepassId = $gatepassId AND GI.status = 8")->queryAll();

    if($totalItemsInGatepass == $totalReturnedItemsInGatepass){
        GatePass::model()->updateByPk($gatepassId,array('status'=>10));
        Yii::app()->db->createCommand("UPDATE items_for_gatepass IFG
                SET IFG.status = 10
                WHERE IFG.id IN (SELECT GI.item_for_gatepass_id FROM gatepass_items GI WHERE GI.gatepassId = $gatepassId )")->execute();
    }
    $this->_sendResponse(200,CJSON::encode(array('status'=>true)));
}

}
