<?php

class EmployeeController extends Controller {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column1';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view', 'ModelAddContact','Employeesalary','Salaryoverrit','GetEmployeeSlary','ChangeSalary','ChangeProfilePicture','AddIssueTshirt','AddIssueShoePair','GetTshirtIssues','GetShoeIssues','UpdateTshirtIssueTable','UpdateShoeIssueTable','AddStatusDetail','ActiveEmployee','GetEmployeeByNic','GetAllEmployees'),
                'users' => array('*'),
            ),
            /* array('allow', // allow authenticated user to perform 'create' and 'update' actions
              'actions'=>array('create','update'),
              'users'=>array('@'),
              ), */
            array('allow', // allow only the owner to perform 'view' 'update' 'delete' actions
                'actions' => array('create'),
                'expression' => 'Yii::app()->user->can("Employee_Create")',
            ),
            array('allow', // allow only the owner to perform 'view' 'update' 'delete' actions
                'actions' => array('update'),
                'expression' => 'Yii::app()->user->can("Employee_Update")',
            ),
            array('allow', // allow only the owner to perform 'view' 'update' 'delete' actions
                'actions' => array('view'),
                'expression' => 'Yii::app()->user->can("Employee_View")',
            ),
            array('allow', // allow only the owner to perform 'view' 'update' 'delete' actions
                'actions' => array('ChangeSalary'),
                'expression' => 'Yii::app()->user->can("Employee_ChangeSalary")',
            ),
            array('allow', // allow only the owner to perform 'view' 'update' 'delete' actions
                'actions' => array('Salaryoverwrite'),
                'expression' => 'Yii::app()->user->can("Employee_Salaryoverwrite")',
            ),
            array('allow', // allow only the owner to perform 'view' 'update' 'delete' actions
                'actions' => array('Employeesalary'),
                'expression' => 'Yii::app()->user->can("Employee_Employeesalary")',
            ),
            array('allow', // allow only the owner to perform 'view' 'update' 'delete' actions
                'actions' => array('ModelAddContact'),
                'expression' => 'Yii::app()->user->can("Employee_ModelAddContact")',
            ),
            array('allow', // allow only the owner to perform 'view' 'update' 'delete' actions
                'actions' => array('Employeesalary'),
                'expression' => 'Yii::app()->user->can("Employee_Employeesalary")',
            ),
            array('allow', // allow only the owner to perform 'view' 'update' 'delete' actions
                'actions' => array('GetEmployeeSlary'),
                'expression' => 'Yii::app()->user->can("Employee_GetEmployeeSlary")',
            ),
            
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete'),
                'users' => array('admin'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $contact = new Contact;
        $employeesalary = new Employeesalary; 
        $models = Contact::model()->findAllByAttributes(array('employeeid' => $id));
        $emplosalary = Employeesalary::model()->findByAttributes(array('employeeid' => $id));
        $emplosalary = Employeesalary::model()->findByAttributes(array('employeeid' => $id));
        
        $this->render('view', array(
            'model' => $this->loadModel($id), 'contact' => $contact,'employeesalary'=>$employeesalary,'emplosalary'=>$emplosalary, 'models' => $models,
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new Employee;

        if (isset($_POST['Employee'])) {
            $model->attributes = $_POST['Employee'];
            $model->TeamStatus = 0;
            $model->status_description = "";
            if ($model->save()) {
              
                $employeedesigna = new EmployeeDesignation;
                $employeedesigna->Status = 1;
                $employeedesigna->EmployeeId = $model->id;
                $employeedesigna->DesignationId = $model->designationid;
                $date = date('Y-m-d H:i:s');
                $employeedesigna->DateTime = $date;
                if($employeedesigna->save()){

                    $designationSalary = DesignationSalary::model()->findByAttributes(
                        array(
                                "DesignationId" => $model->designationid,
                                "Status" => 1
                            )
                    );

                    $monthlyWage = $designationSalary != null ? $designationSalary->MonthlySalary : 0;
                    
                    $dailyWage = Yii::app()->paymentUtil->getDayWage($monthlyWage,$model->paymentmethod,"WagesBoard");
                    $hourlyRate = Yii::app()->paymentUtil->getHourlyRate($monthlyWage,$model->paymentmethod,"WagesBoard");
                    $doubleOTRate = Yii::app()->paymentUtil->getDoubleOTRate($monthlyWage,$model->paymentmethod,"WagesBoard");
                    $normalOTRate = Yii::app()->paymentUtil->getOvetimeRateNormalDay($monthlyWage,$model->paymentmethod,"WagesBoard");

                    $empSalary = new Employeesalary;
                    $empSalary->employeeid = $model->id;
                    $empSalary->monthsalary = $monthlyWage;
                    $empSalary->DalySalary = $dailyWage;
                    $empSalary->HourlyRate = $hourlyRate;
                    $empSalary->DoubleOTRate = $doubleOTRate;
                    $empSalary->OTRate = $normalOTRate;
                    $empSalary->CreatedBy = Yii::app()->user->id;
                    $empSalary->CreatedOn = $date;
                    $empSalary->Status = 1;
                    $empSalary->save();
                }
                $this->redirect(array('view', 'id' => $model->id));
            }
            
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

// Uncomment the following line if AJAX validation is needed
// $this->performAjaxValidation($model);

        if (isset($_POST['Employee'])) {
            $model->attributes = $_POST['Employee'];
            if ($model->save()){
                $employeedesigna = new EmployeeDesignation;
                $employeedesigna::model()->updateAll(array('Status' => 0), 'EmployeeId ="' . $id . '"');
                $employeedesigna->Status = 1;
                $employeedesigna->EmployeeId = $model->id;
                $employeedesigna->DesignationId = $model->designationid;
                $date = date('Y-m-d H:i:s');
                $employeedesigna->DateTime = $date;
                $employeedesigna->save();
            }
            $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
// we only allow deletion via POST request
            $this->loadModel($id)->delete();

// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('Employee');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new Employee('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Employee']))
            $model->attributes = $_GET['Employee'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = Employee::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'employee-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionModelAddContact() {
        $contact = new Contact;
        $contact->number = $_POST['number'];
        $contact->type = $_POST['type'];
        $contact->employeeid = $_POST['employeeid'];
        $contact->address = $_POST['address'];
        $contact->save();
    }
    //===========================================================
    public function actionAddStatusDetail() {
        $model = new EmployeeStatusHistory;
        $date = $_POST['selecteddate'];
        $description = $_POST['description'];
        $employeeid = $_POST['employeeid'];
        Employee::model()->updateAll(array('statusId'=> 2,), 'id ="' . $employeeid . '"');
        $model->emp_id = $employeeid;
        $model->affective_date = $date;
        $model->description = $description;
        $model->status_id = 2;
        $model->responsible_person = Yii::app()->user->id;
        $model->save();
       
    }
    //===========================================================
    public function actionActiveEmployee(){
        $model = new EmployeeStatusHistory;
        $employeeid = $_POST['employeeid'];
        Employee::model()->updateAll(array('statusId'=> 1,), 'id ="' . $employeeid . '"');
        $model->emp_id = $employeeid;
        $model->status_id = 1;
        $model->description = "Active Employee";
        $model->responsible_person = Yii::app()->user->id;
        $time = date("Y-m-d  -  h:i:sa");
        $model->affective_date = $time;
        $model->save();

    }
    //===========================================================

    public function actionEmployeesalary() {
        
        
        $employeesalary = new Employeesalary;
        $empid = $_POST['employeeid'];
        
        $emplosalary = Employeesalary::model()->findByAttributes(array('employeeid' => $empid,'Status'=>1));
       
        if(empty($emplosalary)){
        $employeesalary->employeeid = $_POST['employeeid'];
        $employeesalary->monthsalary = $_POST['monthlysalary'];
        $employeesalary->DalySalary =0;
        
        $monthsalary = $employeesalary->monthsalary;
        $hourlyrate = $monthsalary/200;
        $employeesalary->HourlyRate = $hourlyrate;
        
        $NOT = $hourlyrate * 1.5;
        $employeesalary->OTRate = $NOT;
        
        $DOT = $hourlyrate * 2;
        $employeesalary->DoubleOTRate = $DOT;
        
        $employeesalary->CreatedBy = yii::app()->user->id; 
        $employeesalary->CreatedOn = date("Y-m-d H:i");
        $employeesalary->Status = 1;
        $employeesalary->ActiveStatus = 0;
         
        $employeesalary->save(); 
         
        }
        else {
            
            $monthsalary = $_POST['monthlysalary'];
            $hourlyrate = $monthsalary/200;
            $NOT = $hourlyrate * 1.5;
            $DOT = $hourlyrate * 2;
        
            Employeesalary::model()->updateAll(array('monthsalary' => $monthsalary,'CreatedOn'=>date("Y-m-d H:i"),'CreatedBy'=>yii::app()->user->id,'HourlyRate'=>$hourlyrate,'OTRate'=>$NOT,'DoubleOTRate'=>$DOT),"employeeid=" . $empid . " AND Status =". 1 ."" );
               
        }
       
    }

    public function actionGetEmployeeSlary(){
        $employeeid = $_POST['Employeeid'];

        $empSalaries = Employeesalary::model()->findAllByAttributes(array("employeeid"=>$employeeid));

        foreach($empSalaries as $empSalary){
            echo '<tr>';
            echo '<td>'.$empSalary->monthsalary.'</td>';
            echo '<td>'.$empSalary->HourlyRate.'</td>';
            echo '<td>'.$empSalary->DoubleOTRate.'</td>';
            echo '<td>'.$empSalary->OTRate.'</td>';
            echo '<td>'.$empSalary->CreatedOn.'</td>';
            echo '<td>'.($empSalary->salaryChanged == '1' ? '<span class="label label-success">Changed</span>' :'<span class="label label-info">Default</span>').'</td>';
            echo '<td>'.($empSalary->Status == '1' ? '<span class="label label-success">Active</span>' :'<span class="label label-danger">InActive</span>').'</td>';
            echo '</tr>';
        }
    }

  
    public function actionChangeSalary(){

        $employeeid = $_POST['Employeeid'];
        $monthlyWage =  $_POST['MonthlyWage'];

        $employee = Employee::model()->findByPk($employeeid);        
        $dailyWage = Yii::app()->paymentUtil->getDayWage($monthlyWage,$employee->paymentmethod,"WagesBoard");
        $hourlyRate = Yii::app()->paymentUtil->getHourlyRate($monthlyWage,$employee->paymentmethod,"WagesBoard");
        $doubleOTRate = Yii::app()->paymentUtil->getDoubleOTRate($monthlyWage,$employee->paymentmethod,"WagesBoard");
        $normalOTRate = Yii::app()->paymentUtil->getOvetimeRateNormalDay($monthlyWage,$employee->paymentmethod,"WagesBoard");
        Employeesalary::model()->updateAll(array('Status' => 0), 'Status = 1 AND employeeid = '.$employeeid.'');

        $empSalary = new Employeesalary;
        $empSalary->employeeid = $employeeid;
        $empSalary->monthsalary = $monthlyWage;
        $empSalary->DalySalary = $dailyWage;
        $empSalary->HourlyRate = $hourlyRate;
        $empSalary->DoubleOTRate = $doubleOTRate;
        $empSalary->OTRate = $normalOTRate;
        $empSalary->CreatedBy = Yii::app()->user->id;
        $empSalary->CreatedOn = date("Y-m-d H:i");
        $empSalary->Status = 1;
        $empSalary->salaryChanged = 1;
        $empSalary->save();
    }

    public function actionSalaryoverwrite() {
        $employeesalary = new Employeesalary;
        $status = $_POST['Checkevent'];
        $employeeid = $_POST['Employeeid'];
        
        $designation = EmployeeDesignation::model()->findByAttributes(array('EmployeeId' => $employeeid));
        $desigid = $designation->DesignationId;
        $siteid = Yii::app()->user->data()->SiteId;
        $designatinsalary = DesignationSalary::model()->findByAttributes(array('DesignationId' => $desigid,'Status'=>1,'Siteid'=>$siteid));
       
        $hourlyrate = $designatinsalary->MonthlySalary/200;
        $NOT = $hourlyrate * 1.5;
        $DOT = $hourlyrate * 2;
        $MonthlySalary = $designatinsalary->MonthlySalary;
        $Dalysalary = $designatinsalary->DailySalary;
        
        
        Employeesalary::model()->updateAll(array('ActiveStatus' => 0),'employeeid="' . $employeeid . '"' );
         
        if ($status == 0){
                
        $emplosalary = Employeesalary::model()->findByAttributes(array('employeeid' => $employeeid,'Status'=>2));
        
        if(empty($emplosalary)){
        
        $employeesalary->employeeid = $employeeid;
        $employeesalary->monthsalary = $MonthlySalary;
        $employeesalary->DalySalary =$Dalysalary;
        $employeesalary->HourlyRate = $hourlyrate; 
        $employeesalary->OTRate = $NOT;     
        $employeesalary->DoubleOTRate = $DOT;        
        $employeesalary->CreatedBy = yii::app()->user->id; 
        $employeesalary->CreatedOn = date("Y-m-d H:i");
        $employeesalary->Status = 2;
        $employeesalary->ActiveStatus = 1;
        $employeesalary->save();
       
        $employeesal= CJSON::encode($employeesalary);
        echo $employeesal;
         
        }
         else {
            Employeesalary::model()->updateAll(array('ActiveStatus' => 1),"employeeid=" . $employeeid . " AND Status =". 2 ."" );
             
            $employeesal2= CJSON::encode($emplosalary); 
            echo $employeesal2;                   
              
        }
        }
 else {
     Employeesalary::model()->updateAll(array('ActiveStatus' => 1),"employeeid=" . $employeeid . " AND Status =". 1 ."" );
            
     $emplosalary22 = Employeesalary::model()->findByAttributes(array('employeeid' => $employeeid,'Status'=>1));
     
     $employeesal3= CJSON::encode($emplosalary22);
     echo $employeesal3;
 }
              
    }

    public function actionGetTshirtIssues(){
        //Search for t-shirt issues for the relevant employee  

        $employeeid = $_POST['Employeeid'];
        $tshirtIssues = EmployeeTshirt::model()->findAllBySql("select * from employee_tshirt where empID = $employeeid");
        $employee = Employee::model()->findByPk($employeeid);
               
        $tshirt = Tshirt::model()->findByPk($employee->tshirtsize);

        foreach($tshirtIssues as $issue){
           echo '<tr>';
           echo '<td>'.$tshirt->type.'</td>'; 
           echo '<td>'.$issue->issuedDate.'</td>';
        
            if($issue->Status=='Returned'){
            echo '<td>'.$issue->returnedDate.'</td>';
            echo '<td>'.$issue->Status.'</td>';
            echo '<td> 
                <input type="checkbox" checked="checked" name="myTextEditBox1" value='.$issue->issueID.' onchange="changeContentTshirtIssues('.$issue->issueID.',this.checked)"
                style="margin-left:auto; margin-right:auto;">
                </td>';
                
            }

            else{
            echo '<td>'.'0000-00-00'.'</td>';
            echo '<td>'.$issue->Status.'</td>';
            echo '<td> 
                 <input type="checkbox" name="myTextEditBox1" value='.$issue->issueID.' onchange="changeContentTshirtIssues('.$issue->issueID.',this.checked)"
                 style="margin-left:auto; margin-right:auto;">
                </td>';
                
            }
          
            echo '</tr>';
        }
    }


    public function actionGetShoeIssues(){
        //Search for shoe issues for the relevant employee  

        $employeeid = $_POST['Employeeid'];                 
        $shoeIssues  = EmployeeShoe::model()->findAllBySql("select * from employee_shoe where empID = $employeeid");
        $employee = Employee::model()->findByPk($employeeid);
        
        $shoe = Shoes::model()->findByPk($employee->shoesize);
         
        foreach($shoeIssues as $Shoeissue){
            echo '<tr>';           
            echo '<td>'. $shoe->type.'</td>'; 
            echo '<td>'.$Shoeissue->issuedDate.'</td>';         
            
            if($Shoeissue->Status=='Returned'){
                echo '<td>'.$Shoeissue->returnedDate.'</td>';
                echo '<td>'.$Shoeissue->Status.'</td>';
                echo '<td> 
                        <input  type="checkbox" checked="checked" name="myTextEditBox" value='.$Shoeissue->issueID.' onchange="changeContentShoeIssues('.$Shoeissue->issueID.',this.checked)"
                        style="margin-left:auto; margin-right:auto;">
                    </td>';
            }

            else{
                echo '<td>'.'0000-00-00'.'</td>';
                echo '<td>'.$Shoeissue->Status.'</td>';
                echo '<td> 
                        <input type="checkbox"    name="myTextEditBox" value='.$Shoeissue->issueID.'  onchange="changeContentShoeIssues('.$Shoeissue->issueID.',this.checked)"
                        style="margin-left:auto; margin-right:auto;">
                    </td>';
            }

            
            echo '</tr>';
        }
    }


    public function actionAddIssueTshirt(){

        // Issuing a t shirt
    
        $employeeid = CJSON::decode($_POST['Employeeid']);
        $tshirtIssue = new EmployeeTshirt;
        $tshirtIssue->empID = $employeeid;
        $tshirtIssue->issuedDate = $_POST['IssuedDate'];
        $tshirtIssue->save();
     }
     

    public function actionAddIssueShoePair(){

        // Issuing a pair of shoes
           
        $employeeid = CJSON::decode($_POST['Employeeid']); 
        $shoeIssue = new EmployeeShoe;
        $shoeIssue->empID = $employeeid;
        $shoeIssue->issuedDate = $_POST['ShoesIssuedDate'];         
        $shoeIssue->save();
        }

    public function actionUpdateShoeIssueTable(){

        //update t shirt issues
       
        $issueID =$_POST['shoeIssueID'];
        $status = $_POST['shoeIssueStatus'];
        if($status=='true'){
            EmployeeShoe::model()->updateAll(array('returnedDate'=>date('Y-m-d'),'Status' => 'Returned'),"issueID=" .$issueID."" );
        }
        else{
            EmployeeShoe::model()->updateAll(array('returnedDate'=>null,'Status' => 'Not Returned'),"issueID=" .$issueID."");
        }
       
    }

    public function actionUpdateTshirtIssueTable(){

        //update shoe issues
        
        $issueID =$_POST['tshirtIssueID'];
        $status =$_POST['tshirtIssueStatus'];
   
        if($status=='true'){
            EmployeeTshirt::model()->updateAll(array('returnedDate'=>date('Y-m-d'),'Status' => 'Returned'),"issueID=" .$issueID."" );
            
        }
        else{
            EmployeeTshirt::model()->updateAll(array('returnedDate'=>null,'Status' => 'Not Returned'),"issueID=" .$issueID."");
          
        }
       
         
    }
    


    public function actionChangeProfilePicture(){
       
        $uploads_dir = Yii::getPathOfAlias("webroot").'/themeassets/employee-images';
        $tmp_name = $_FILES["file"]["tmp_name"];
        $name = basename($_FILES["file"]["name"]);
       
        $employee = $_POST["employee"];
        $type = $_FILES["file"]["type"];
        $extension = explode('/',$type);
        $filename = $employee.".".$extension[1];
        $newpath = "$uploads_dir/$filename";  
        $newpath2 = '/themeassets/employee-images/'.$filename;
        Employee::model()->updateAll(array('profileImage'=> $newpath2),"id=".$employee);
        move_uploaded_file($tmp_name,$newpath);
        
        
    }

    public function actionGetAllEmployees(){
        $employees = Employee::model()->findAll();
        $this->_sendResponse(200, CJSON::encode($employees));
    }

    public function actionGetEmployeeByNic(){

        $body = @file_get_contents('php://input');
        $obj = json_decode($body);
        
        $nic = $obj->nic;

        $employee = Employee::model()->findByAttributes(array("nic"=>$nic));
        $this->_sendResponse(200, CJSON::encode($employee));
    }
}


