<?php

class DesignationController extends Controller
{
/**
* @var string the default layout for the views. Defaults to '//layouts/column2', meaning
* using two-column layout. See 'protected/views/layouts/column2.php'.
*/
public $layout='//layouts/column1';

/**
* @return array action filters
*/
public function filters()
{
return array(
'accessControl', // perform access control for CRUD operations
);
}

/**
* Specifies the access control rules.
* This method is used by the 'accessControl' filter.
* @return array access control rules
*/
public function accessRules()
{
return array(
array('allow',  // allow all users to perform 'index' and 'view' actions
'actions'=>array('index','view'),
'users'=>array('*'),
),
array('allow', // allow authenticated user to perform 'create' and 'update' actions
'actions'=>array('create','update','SearchByDesignation','DesignationPdf','Excel'),
'users'=>array('@'),
),
array('allow', // allow admin user to perform 'admin' and 'delete' actions
'actions'=>array('admin','delete'),
'users'=>array('admin'),
),
array('deny',  // deny all users
'users'=>array('*'),
),
);
}

/**
* Displays a particular model.
* @param integer $id the ID of the model to be displayed
*/
public function actionView($id)
{
$this->render('view',array(
'model'=>$this->loadModel($id),
));
}

/**
* Creates a new model.
* If creation is successful, the browser will be redirected to the 'view' page.
*/
public function actionCreate()
{
$model=new Designation;

// Uncomment the following line if AJAX validation is needed
// $this->performAjaxValidation($model);

if(isset($_POST['Designation']))
{
$model->attributes=$_POST['Designation'];
if($model->save())
$this->redirect(array('view','id'=>$model->id));
}

$this->render('create',array(
'model'=>$model,
));
}

/**
* Updates a particular model.
* If update is successful, the browser will be redirected to the 'view' page.
* @param integer $id the ID of the model to be updated
*/
public function actionUpdate($id)
{
$model=$this->loadModel($id);

// Uncomment the following line if AJAX validation is needed
// $this->performAjaxValidation($model);

if(isset($_POST['Designation']))
{
$model->attributes=$_POST['Designation'];
if($model->save())
$this->redirect(array('view','id'=>$model->id));
}

$this->render('update',array(
'model'=>$model,
));
}

/**
* Deletes a particular model.
* If deletion is successful, the browser will be redirected to the 'admin' page.
* @param integer $id the ID of the model to be deleted
*/
public function actionDelete($id)
{
if(Yii::app()->request->isPostRequest)
{
// we only allow deletion via POST request
$this->loadModel($id)->delete();

// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
if(!isset($_GET['ajax']))
$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
}
else
throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
}

/**
* Lists all models.
*/
public function actionIndex()
{
$dataProvider=new CActiveDataProvider('Designation');
$this->render('index',array(
'dataProvider'=>$dataProvider,
));
}

/**
* Manages all models.
*/
public function actionAdmin()
{
$model=new Designation('search');
$model->unsetAttributes();  // clear any default values
if(isset($_GET['Designation']))
$model->attributes=$_GET['Designation'];

$this->render('admin',array(
'model'=>$model,
));
}

//==================================================================
public function actionSearchByDesignation(){
    $model = new SearchDesignation;

    if(isset($_POST['SearchDesignation'])){
        $model-> attributes = $_POST['SearchDesignation'];
        if($model->validate()){
            // print_r($model->designationId);
            // die;
            $logs = Yii::app()->db->createCommand("SELECT DS.MonthlySalary salary,D.type type,E.nic nic,E.id id,E.Namewithini name,S.location site,A.name account 
                    FROM designation D INNER JOIN employee_designation ED ON d.id = ED.DesignationId INNER JOIN designation_salary DS ON ED.DesignationId = DS.DesignationId 
                    INNER JOIN sites S ON DS.Siteid = S.id INNER JOIN employee E ON ED.EmployeeId = E.id INNER JOIN accounts A ON S.id = A.siteid 
                    WHERE d.id = '".$model->designationId."' AND ED.Status = 1 And DS.Status = 1")->queryAll();
           
            $this->render('viewDesignation',array('logs'=>$logs,'model'=>$model));
           
        }
    }else{
        $this->render('searchDesignationForm',array('model'=>$model,));
    }

    

}
//==================================================================
public function actionDesignationPdf(){
    $logs = CJSON::decode($_POST['logs']);
    $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
    $mPDF1->setFooter('{PAGENO}');
    $mPDF1->WriteHTML($this->renderPartial('viewDesignationPDF',array('logs'=>$logs),true));
    $file_name= $logs[0]['type'].'.pdf';
    $time = date("Y-m-d  -  h:i:sa");
    $mPDF1->SetFooter('Report generated by '.Yii::app()->user->name.' on ' .$time.  '<br/> powered by Eimsky Business Solutions Pvt Ltd');
    
    
    ob_end_clean();
    $mPDF1->Output($file_name,EYiiPdf::OUTPUT_TO_DOWNLOAD );
}

//==================================================================
public function actionExcel(){
    $objPHPExcel = new PHPExcel();
    $logs = CJSON::decode($_POST['logs']);

    

    $objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('A1', 'ID')
    ->setCellValue('B1', 'NIC')
    ->setCellValue('C1', 'NAME')
    ->setCellValue('D1', 'SITE')
    ->setCellValue('E1', 'ACCOUNT');
    $y = 2;

    
    foreach($logs as $logs){
        
       
        $objPHPExcel->setActiveSheetIndex(0)
        ->setCellValue('A'.$y, $logs['id'])
        ->setCellValue('B'.$y, $logs['nic'])
        ->setCellValue('C'.$y, $logs['name'])
        ->setCellValue('D'.$y, $logs['site'])
        ->setCellValue('E'.$y, $logs['account']);
        $y++;
       

    }
    $objPHPExcel->getActiveSheet()->setTitle($logs['type']);
 
    $objPHPExcel->setActiveSheetIndex(0);
     
    ob_end_clean();
    ob_start();
    
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename='.$logs['type'].'.xls');
    header('Cache-Control: max-age=0');
    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
    $objWriter->save('php://output');
  }

//==================================================================

/**
* Returns the data model based on the primary key given in the GET variable.
* If the data model is not found, an HTTP exception will be raised.
* @param integer the ID of the model to be loaded
*/
public function loadModel($id)
{
$model=Designation::model()->findByPk($id);
if($model===null)
throw new CHttpException(404,'The requested page does not exist.');
return $model;
}

/**
* Performs the AJAX validation.
* @param CModel the model to be validated
*/
protected function performAjaxValidation($model)
{
if(isset($_POST['ajax']) && $_POST['ajax']==='designation-form')
{
echo CActiveForm::validate($model);
Yii::app()->end();
}
}
}
